#include "mbed.h"
#include "cstdlib"
#include "IRSensor.h"
#include "Servo.h"
//#include "Pixy.h"
#include "Farbauswertung.h"
#include "Fahren.h"
#include "liftAnsteuerung.h"
#include "Pixy.h"
#include "PID_Control.h"

/**
*Aus- und Eingänge initialisieren
*/
//Button
DigitalIn       usrButton(USER_BUTTON);

//Serielle Ports deklarieren
Serial          pc(USBTX,USBRX);
Serial          cam(PA_9, PA_10);
//Berechnungsklassen
PID_Control     pid;
//IRSensoren
DigitalOut      enable(PC_1);
DigitalOut      bit0(PH_1);
DigitalOut      bit1(PC_2);
DigitalOut      bit2(PC_3);
AnalogIn        distance(PB_1);
//Motoren
DigitalOut      enableMotorDriver(PB_2);
PwmOut          pwmLeft(PA_8);
PwmOut          pwmRight(PA_9);
//Farbauswertung
AnalogIn        SensorG(PA_0);
AnalogIn        SensorR(PA_1);
Servo           ServoAusw(PB_7);
Servo           ServoFoerder(PC_7);
//Lift
Servo           ServoLift(PB_6);
//Kamera
Pixy            pixy(cam);

//Robotersteuerung
LiftAnsteuerung lift(7, 1, ServoLift);
Farbauswertung  farbauswertung(&SensorG, &SensorR, ServoAusw, ServoFoerder, lift, 4, 8);
Fahren          fahren(enable, bit0, bit1, bit2, distance, enableMotorDriver, pwmLeft, pwmRight, pixy, pid);


int main() 
{
    /*
    *Für Konsolenausgaben diese Zeilen aktivieren und in der While die dementsprechende Methode aufrufen.
    */
    //farbauswertung.setSerialOutput(&pc);
    //fahren.setSerialOutput(&pc);
    
    Ticker auswertung;
    Ticker drive;
    
    pid.setPIDValues( 0.001f, 0.001f, 0.00015f, 0.3f, -0.3f, 1000);
    fahren.fahrInit();
    
    while(usrButton){
        wait(1.0);
    }
    
    auswertung.attach(&farbauswertung, &Farbauswertung::auswertung, 0.5);
    
    drive.attach(&fahren, &Fahren::fahrRutine, 0.02);
    
    while (1) {
        wait(10.0);
        //farbauswertung.printState();
        //fahren.printState();
    }
}
