#ifndef FARBAUSW_H
#define FARBAUSW_H

#include <mbed.h>
#include <cstdlib>
#include "Farbsensor.h"
#include "Servo.h"
#include "liftAnsteuerung.h"

class Farbauswertung 
{
public:
    //Konstruktoren und Destruktoren
    Farbauswertung(AnalogIn* SensorG, AnalogIn* SensorR, Servo& servoAusw, Servo& servoFoerder, LiftAnsteuerung& lift, int verzEin, int verzAus);
    Farbauswertung();
    virtual     ~Farbauswertung();
    
    //Public Methoden
    void        auswertung();
    void        setSerialOutput(Serial *pc);
    void        printState();
    void        printSens();
    
private:
    //Private Methoden
    
    //Private Eigenschaften
    AnalogIn*   SensorG;
    AnalogIn*   SensorR;
    Servo&      servoAusw;
    Servo&      servoFoerder;
    
    static const uint16_t merkerSize = 300;
    uint8_t     merker[merkerSize];
    uint8_t     m_verzEin;
    uint8_t     m_verzAus;
    uint16_t    p1, p2;
    uint8_t     sum;
    float       valInG;
    float       valInR;
    uint8_t     zustand;
    enum        zustand {gruen=0, rot};
    Farbsensor  farbsensor;
    LiftAnsteuerung& lift;
    Serial      *pc;
};

#endif
