#include "mbed.h"
#include "cstdlib"
//#include <cmath>
#include "Farbauswertung.h"

//Konstruktor
Farbauswertung::Farbauswertung(AnalogIn* SensorG, AnalogIn* SensorR, Servo& _servoAusw, Servo& _servoFoerder, LiftAnsteuerung& _lift, int verzEin, int verzAus) : servoAusw(_servoAusw), servoFoerder(_servoFoerder), lift(_lift)
{
    this->SensorG = SensorG;
    this->SensorR = SensorR;
    m_verzEin = verzEin;
    m_verzAus = verzAus;
    p1 = 0;
    p2 = merkerSize - verzEin;
    farbsensor.init(SensorG, SensorR);
    zustand = gruen;
    memset(merker, 0, merkerSize);
}

//Destruktor
Farbauswertung::~Farbauswertung() {}

void Farbauswertung::setSerialOutput(Serial *pc)
{
    this->pc = pc;
}

//Methoden
void Farbauswertung::printState()
{
    if (pc) {
        pc->printf("Gruen: %f\tRot: %f\tStatus: %d\n\r", farbsensor.readg(), farbsensor.readr(), zustand);
    }
}

void Farbauswertung::auswertung()
{
    servoFoerder = 0.2f;

    valInG = farbsensor.readg();
    valInR = farbsensor.readr();
    //Zustände am Farbsensor ins Array schreiben
    if ((valInG=68.0 && valInG<=70.0 && valInR>=70.0 && valInR<=71.6)|| (valInG>=77.2 && valInG<=77.39 && valInR>=75.0 && valInR<=77.0) || (valInG>=75.0 && valInG<=76.0 && valInR>=73.0 && valInR<=74.0)) {
        zustand = rot;
    } else {
        zustand = gruen;
    }
    merker[p1] = zustand;

    //Zustände an der Klappe abrufen und Klappe öffnen und schliessen
    sum = 0;
    uint8_t i = 0;
    while (i<m_verzAus) {
        if ((p2+i) < merkerSize) {
            sum += merker[p2+i];
        } else {
            sum += merker[p2+i-merkerSize];
        }
        i++;
    }
    
    //Klappe öffnen oder schliessen
    if (sum > 0) {
        servoAusw = 1.0f;
    } else {
        servoAusw = 0.01f;
    }
    
    //Liftmodul alle vier Durchgänge aufrufen
    if (p1%4 == 0) {
        lift.steuerung();
    }
    
    //Zähler aufsummieren oder zurücksetzen.
    if (p1 < (merkerSize-1)) {
        p1++;
    } else {
        p1 = 0;
    }
    if (p2 < (merkerSize-1)) {
        p2++;
    } else {
        p2 = 0;
    }
}
