#ifndef FAHREN_H
#define FAHREN_H

#include <mbed.h>
#include <cstdlib>
#include "IRSensor.h"
//#include "CamAusw.h"
#include "Pixy.h"
#include "PID_Control.h"

class Fahren
{
public:
    //Konstruktoren und Destruktoren
    Fahren(DigitalOut& enable, DigitalOut& bit0, DigitalOut& bit1, DigitalOut& bit2, AnalogIn& distance, DigitalOut& enableMotorDriver, PwmOut& pwmLeft, PwmOut& pwmRight, Pixy& pixy, PID_Control& pid);
    Fahren();
    virtual ~Fahren();
    
    //Public Methoden
    void        setSerialOutput(Serial *pc);
    void        printState();
    void        fahrInit();
    void        fahrRutine();

private:
    /**
     * Private Methoden
     */
    
    /**
     * Private Eigenschaften
     */ 
    //Digitale, Analoge und Serielle In/Outputs
    IRSensor        sensors[6];
    DigitalOut&     enable;
    DigitalOut&     bit0;
    DigitalOut&     bit1;
    DigitalOut&     bit2;
    AnalogIn&       distance;
    DigitalOut&     enableMotorDriver;
    PwmOut&         pwmLeft;
    PwmOut&         pwmRight;
    Pixy&           pixy;
    PID_Control&    pid;
    //Variabeln
    uint8_t         state;
    uint8_t         searchTimer;
    uint8_t         zurTimer;
    enum            state {gerade=0, cam, rechts, links, drehen_ran, drehen_r, drehen_l, zurueck, zurueck_l, zurueck_r, hart_zurueck_r, hart_zurueck_l, camSearchRot, camSearchDrive};
    Serial          *pc;
    float           e;
    float           diff;
    float           s0, s1, s2, s3, s4, s5;
    //Konstante
    static const double wenden =0.22;
    static const double wand =0.07;
};

#endif
