#include "mbed.h"
#include "cstdlib"
#include <cmath>
#include "Fahren.h"


//Konstruktor
Fahren::Fahren(DigitalOut& _enable, DigitalOut& _bit0, DigitalOut& _bit1, DigitalOut& _bit2, AnalogIn& _distance, DigitalOut& _enableMotorDriver, PwmOut& _pwmLeft, PwmOut& _pwmRight, Pixy& _pixy, PID_Control& _pid) : enable(_enable), bit0(_bit0), bit1(_bit1), bit2(_bit2), distance(_distance), enableMotorDriver(_enableMotorDriver), pwmLeft(_pwmLeft), pwmRight(_pwmRight), pixy(_pixy),  pid(_pid)
{
    state = 0;
    e = 0.0;
    diff = 0.0;
    searchTimer = 0;
    zurTimer = 40;
}

//Destruktor
Fahren::~Fahren() {}

//Methoden
void Fahren::setSerialOutput(Serial *pc)
{
    this->pc = pc;
}

void Fahren::printState()
{
    if(pc) {
        switch (state) {
            case gerade:
                pc->printf("Gerade\n\r");
                break;
            case cam:
                pc->printf("Kamerafahrt\n\r");
                break;
            case camSearchRot:
                pc->printf("Kamerafahrt Rotation\n\r");
                break;
            case camSearchDrive:
                pc->printf("Kamerafahrt Fahrsuche\n\r");
                break;
            case rechts:
                pc->printf("Rechts\n\r");
                break;
            case links:
                pc->printf("Links\n\r");
                break;
            case drehen_ran:
                pc->printf("Drehen Random\n\r");
                break;
            case drehen_l:
                pc->printf("Drehen Links\n\r");
                break;
            case drehen_r:
                pc->printf("Drehen Rechts\n\r");
                break;
            case zurueck:
                pc->printf("Gerade Zurueck\n\r");
                break;
            case zurueck_l:
                pc->printf("Links Zurueck\n\r");
                break;
            case zurueck_r:
                pc->printf("Rechts Zurueck\n\r");
                break;
            case hart_zurueck_r:
                pc->printf("Rechts Hart-Zurueck\n\r");
                break;
            case hart_zurueck_l:
                pc->printf("Links Hart-Zurueck\n\r");
                break;
        }
    }
}


void Fahren::fahrInit()
{
    pwmLeft = 0.5;
    pwmRight = 0.5;

    for( int ii = 0; ii<6; ++ii) {
        sensors[ii].init(&distance, &bit0, &bit1, &bit2, ii);
        enable=1;
        pwmLeft.period(0.00005);
        pwmRight.period(0.00005);
        enableMotorDriver=1;
    }
}

void Fahren::fahrRutine()
{
    //IR-Sensoren auslesen
    s0 = sensors[0];
    s1 = sensors[1];
    s2 = sensors[2];
    s4 = sensors[4];
    s5 = sensors[5];
    
    //Erst prüfen ob aus einem vorhergegangenen Schritt noch eine Aktion ausgeführt werden muss
    if ((state == hart_zurueck_r || state == hart_zurueck_l) && zurTimer<40) {
        zurTimer++;
    }
    
    //Alle Sensoren genügend abstand -> Kamerafahrt
    else if (s0>0.25 && s1>0.22 && s2>0.25 && s4>0.25 && s5>0.22) {
        if ((pixy.getX()>=5 && pixy.getX()<=315) && pixy.getDetects() != 0 ) {
            e = 160-pixy.getX();
            diff = pid.calc( e, 0.005f );
            pwmLeft = 0.65f - diff;
            pwmRight = 0.35f - diff;
            state = cam;
        } else {
            if (searchTimer < 150) {
                pwmLeft = 0.65;
                pwmRight = 0.65;
                searchTimer++;
                state = camSearchRot;
            } else {
                pwmLeft = 0.65f;
                pwmRight = 0.35f;
                searchTimer -= 2;
                state = camSearchDrive;
            }
        }
    } else {
        //Front Links und Recht prüfen ob viel zu nahe
        if (s1<=wand || s5<=wand) { //Abfrage noch ändern
            if(s1<=wand) {
                pwmLeft = 0.45;
                pwmRight = 0.65;
                state = hart_zurueck_r;
                zurTimer = 0;
            } else {
                pwmLeft = 0.35;
                pwmRight = 0.55;
                state = hart_zurueck_l;
                zurTimer = 0;
            }
        }

        //Kontrolle ob zurückgefahren werden muss
        else if (s0<=0.1 && s1<=0.12 && s5<=0.12) {
            if(s2<=0.25) {
                pwmLeft = 0.65;
                pwmRight = 0.65;
                state=zurueck_l;
            } else if(s4<=0.25) {
                pwmLeft = 0.35;
                pwmRight = 0.35;
                state=zurueck_r;
            } else {
                pwmLeft = 0.4;
                pwmRight = 0.6;
                state=zurueck;
            }
        }

        //Kontrolle ob gedreht werden muss
        else if(s0<0.25) {
            if(sensors[1]<=wenden) {
                //Drehen Links
                pwmLeft = 0.3;
                pwmRight = 0.3;
                state = drehen_l;
            } else if(s5<=wenden) {
                //Drehen Rechts
                pwmLeft = 0.7;
                pwmRight = 0.7;
                state = drehen_r;
            } else {
                //Random Drehen
                if (rand()%2==0 && state != drehen_ran) {
                    pwmLeft = 0.3;
                    pwmRight = 0.3;
                } else if (rand()%2 != 0 && state != drehen_ran) {
                    pwmLeft = 0.7;
                    pwmRight = 0.7;
                }
                state=drehen_ran;
            }
        }

        //Rechtsfahren
        else if(s5<=wenden && s5 >= 0.08) {
            pwmLeft = 0.65;
            pwmRight = 0.45;
            state=rechts;
        }

        //Linksfahren
        else if(s1<=wenden && s1 >= 0.08) {
            pwmLeft = 0.55;
            pwmRight = 0.35;
            state=links;
        }
    }
}
