#include "mbed.h"
#include "Pixy.h"
#include "cstdlib"
 
Pixy pixy(Pixy::UART, PC_5, PB_10);
Serial pc(SERIAL_TX, SERIAL_RX);
 
int main() {
    wait(3);
    //pc.printf("ready\n\r");
    printf("ready\n\r");
    
    pixy.setSerialOutput(&pc);
    while (1) {
        //printf("while");
        static int i = 0;
        int j;
        uint16_t blocks;
  
        blocks = pixy.getBlocks();
  
        if (blocks) {
            i++;
    
            if (i % 50 == 0) {
                //pc.printf("Detected %d:\n\r", blocks);
                printf("Detected %d:\n\r", blocks);
                for (j = 0; j < blocks; j++) {
                    printf("  block %d: ", j);
                    printf("sig: %d x: %d y: %d width: %d height: %d\n", pixy.blocks[j].signature, pixy.blocks[j].x, pixy.blocks[j].y, pixy.blocks[j].width, pixy.blocks[j].height);
                    
                    
                    //pc.printf("  block %d: ", j);
                    //pixy.blocks[j].print(pc);
                }
            }
        }
        wait( 0.01);
    } 
}