#ifndef PIXY_H
#define PIXY_H

#include <mbed.h>

class Pixy
{
public:
    Pixy(Serial& cam);
    
    struct pixy_s {
        uint16_t checksum;
        uint16_t signature;
        uint16_t x;
        uint16_t y;
        uint16_t width;
        uint16_t height;
    };

    //returns the X coordinates of the found object in image space
    int getX();
    int getY();
    int getSignature();
    int getDetects();

private:
    bool startFound;
    void rxCallback();
    int detects;
    Serial& cam;
    pixy_s pixy;
};

#endif