#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(D8, D9, D4, D5, D6, D7); // rs, e, d4-d7
Serial pc (USBTX, USBRX);
AnalogIn eixo_Z(PC_2);
AnalogIn botao_SELECT(A0);
InterruptIn posicao_salva(PA_15);
InterruptIn botao_emergencia(PC_4);
DigitalIn botao_indicador_fonte_externa(PC_10);

BusOut motor_z(PB_1, PB_15, PB_14, PB_13);
float tempo_horario, tempo_anti_horario; //Segundos
int pulsos_horario, pulsos_anti_horario;
int i;
int J_Z;
float deslocamento_horario_Z, deslocamento_anti_horario_Z, deslocamento_total_Z;
float velocidade_Z;
float passo_motor = 18;//5.625/32;
int passo_fuso = 5;
int pegaZ;
int posicao_salva_estado, botao_emergencia_estado;
int fonte_externa;
int SELECT, valor_SELECT;

void rotina_posicao_salva(void);
void rotina_emergencia(void);
void rotida_velocidade_eixo_Z(void);
void rotida_deslocamento_eixo_Z (void);
void rotida_aciona_motor (void);
void rotida_botoes_IHM (void);


int main()
{

    pc.baud(115200);
    motor_z = 0x00;
    posicao_salva.rise(&rotina_posicao_salva);
    botao_emergencia.rise(&rotina_emergencia);
    lcd.locate(0,0);
    lcd.printf("PosicaoZ:");


    while(1) {

        posicao_salva_estado = posicao_salva.read();
        botao_emergencia_estado = botao_emergencia.read();
        J_Z = eixo_Z.read_u16();
        fonte_externa = botao_indicador_fonte_externa.read();
        SELECT = botao_SELECT.read_u16();
        rotida_botoes_IHM();
        
        pc.printf("Select=%d\r\n", valor_SELECT);
        //pc.printf("Z=%4d, PegaZ=%4d, Posicao_salva_estado=%d, Botao_emergencia_estado=%d, Tempo1=%4f, Tempo2=%4f, Pulsos=%d, Deslocamento_Z=%f, Velocidade_Z=%f\r\n", J_Z, pegaZ, posicao_salva_estado, botao_emergencia_estado, tempo_horario, tempo_anti_horario, pulsos_anti_horario, deslocamento_total_Z, velocidade_Z);

        if(fonte_externa == 0) {
            lcd.locate(0,1);
            lcd.printf("%4fmm",deslocamento_total_Z);
//            pc.printf("Fonte=%d\r\n", fonte_externa);
            rotida_aciona_motor();

        }
    }
}


void rotina_posicao_salva()
{
    if(posicao_salva_estado == 0) pegaZ = J_Z;
    else pegaZ = 0;
}

void rotina_emergencia()
{
    if(botao_emergencia_estado == 0) motor_z = 0x00;
}

void rotida_velocidade_eixo_Z()
{
    tempo_horario = -1*J_Z*0.0000028 +0.1875;
    tempo_anti_horario = J_Z*0.000002785 +0.0025;
}

void rotida_deslocamento_eixo_Z()
{
    deslocamento_horario_Z = (passo_fuso*pulsos_horario*passo_motor)/360;
    deslocamento_anti_horario_Z = (passo_fuso*pulsos_anti_horario*passo_motor)/360;
    deslocamento_total_Z = deslocamento_anti_horario_Z - deslocamento_horario_Z;
}

void rotida_botoes_IHM()
{

    if(SELECT > 60000 & SELECT < 65000) valor_SELECT = 1;
    else valor_SELECT = 0;


}


void rotida_aciona_motor()
{

    if(31000 <= J_Z &  J_Z <= 35000) {

        motor_z = 0x00;

    } else {
        if (J_Z > 31000) {
            for(i = 0; i < 4; i++) {
                motor_z = 1 << i;
                rotida_velocidade_eixo_Z();
                rotida_deslocamento_eixo_Z();
                wait(tempo_horario);
                pulsos_horario+=1;
                velocidade_Z = deslocamento_horario_Z/tempo_horario;

            }
        }

        if(J_Z < 35000) {
            for(i = 3; i > -1; i--) {
                motor_z = 1 << i;
                rotida_velocidade_eixo_Z();
                rotida_deslocamento_eixo_Z();
                wait(tempo_anti_horario);
                pulsos_anti_horario+=1;
                velocidade_Z = deslocamento_horario_Z/tempo_horario;

            }
        }
    }


}