#include "mbed.h"
#include "TextLCD.h"
TextLCD lcd(D4, D5, D6, D7, D8, D9);
float t_motor = 0.002;      //delay entre o acionamento de uma bobina do motor e a outra
int hor[] = {12,6,3,9};     //valores que, ao serem convertidos em binário, geram a sequência de acionamento do motor no sentido horário enviando a sequência de 0's e 1's às bobinas
int antihor[] = {3,6,12,9}; //valores que, ao serem convertidos em binário, geram a sequência de acionamento do motor no sentido anti-horário enviando a sequência de 0's e 1's às bobinas
int parado[] = {0,0,0,0};   //valores enviados às bobinas do motor para deixá-lo parado
float coord_x = 0;          //variável que guardará a posição linear do eixo x, ela é incrementada com a conta do deslocamento linear dado um deslocamento angular sempre que o eixo é movimentado depois do referencimaneto
float coord_y = 0;          //variável que guardará a posição linear do eixo y, ela é incrementada com a conta do deslocamento linear dado um deslocamento angular sempre que o eixo é movimentado depois do referencimaneto
float coord_z = 0;          //variável que guardará a posição linear do eixo z, ela é incrementada com a conta do deslocamento linear dado um deslocamento angular sempre que o eixo é movimentado depois do referencimaneto
int est_x = 0;              //variável que indicará o estado do eixo x, pemitindo ou não que ele possa ser avançado depois de atingir o fim de curso
int est_y = 0;              //variável que indicará o estado do eixo y, pemitindo ou não que ele possa ser avançado depois de atingir o fim de curso
int est_z = 0;              //variável que indicará o estado do eixo z, pemitindo ou não que ele possa ser avançado depois de atingir o fim de curso
DigitalIn t_0(PC_13);

//pinos usados pelos botoes de fim de curso
InterruptIn fdc_x(PC_10);
InterruptIn fdc_y(PC_11);
InterruptIn fdc_z(PC_12);

//botoes para movimentacao eixo a eixo
DigitalIn x_mais(PA_0);
DigitalIn x_menos(PA_1);
DigitalIn y_mais(PC_0);
DigitalIn y_menos(PC_1);
DigitalIn z_mais(PC_2);
DigitalIn z_menos(PC_3);

//pinos de saída para os motores
//eixo x
BusOut eixox(PA_15,PA_14,PA_13,PA_12);
//eixo y
BusOut eixoy(PA_11,PA_10,PB_2,PB_1);
//eixo z
BusOut eixoz(PC_9,PC_8,PB_8,PC_6);

//funcao de movimentacao dos motores
void mov_x_menos(){for(int i = 0; i < 4; i++){eixox = antihor[i];wait(t_motor);coord_x -= (5.625*5/32)/360;}}
void mov_y_menos(){for(int i = 0; i < 4; i++){eixoy = antihor[i];wait(t_motor);coord_y -= (5.625*5/32)/360;}}
void mov_z_menos(){for(int i = 0; i < 4; i++){eixoz = antihor[i];wait(t_motor);coord_z -= (5.625*5/32)/360;}}
void mov_x_mais() {for(int i = 0; i < 4; i++){eixox =     hor[i];wait(t_motor);coord_x += (5.625*5/32)/360;}}
void mov_y_mais() {for(int i = 0; i < 4; i++){eixoy =     hor[i];wait(t_motor);coord_y += (5.625*5/32)/360;}}
void mov_z_mais() {for(int i = 0; i < 4; i++){eixoz =     hor[i];wait(t_motor);coord_z += (5.625*5/32)/360;}}

void lim_x(){for(int i = 0; i < 4; i++){eixox = parado[i];wait(t_motor);coord_x += 0;lcd.cls();lcd.printf("Limite de x atingido");lcd.locate(0,2);lcd.printf("Pressione 0 para continuar");printf("\nLimite x apertado");est_x = 1;}}
void lim_y(){for(int i = 0; i < 4; i++){eixoy = parado[i];wait(t_motor);coord_y += 0;lcd.cls();lcd.printf("Limite de y atingido");lcd.locate(0,2);lcd.printf("Pressione 0 para continuar");printf("\nLimite y apertado");est_y = 1;}}
void lim_z(){for(int i = 0; i < 4; i++){eixoz = parado[i];wait(t_motor);coord_z += 0;lcd.cls();lcd.printf("Limite de z atingido");lcd.locate(0,2);lcd.printf("Pressione 0 para continuar");printf("\nLimite z apertado");est_z = 1;}}

int main(){
    fdc_x.fall(&lim_x);
    fdc_y.fall(&lim_y);
    fdc_z.fall(&lim_z);
    while(1){
        if(t_0 == 0){est_x = 0;est_y = 0;est_z = 0;}
        while(x_menos == 0 && est_x == 0){mov_x_menos();}
        while(y_menos == 0 && est_y == 0){mov_y_menos();}
        while(z_menos == 0 && est_z == 0){mov_z_menos();}
        while(x_mais == 0 && est_x == 0){mov_x_mais();}
        while(y_mais == 0 && est_y == 0){mov_y_mais();}
        while(z_mais == 0 && est_z == 0){mov_z_mais();}
        
        lcd.cls();      lcd.printf("X: %4.1f", coord_x);
        lcd.locate(0,1);lcd.printf("Y: %4.1f", coord_y);
        lcd.locate(0,2);lcd.printf("Z: %4.1f", coord_z);
        
        if(x_mais && x_menos && y_mais && y_menos && z_mais && z_menos != 0){
            for(int i = 0; i < 4; i++){eixox = parado[i];}
            for(int i = 0; i < 4; i++){eixoy = parado[i];}
            for(int i = 0; i < 4; i++){eixoz = parado[i];}}
        wait(0.09);      
        }
    }