//local para inclusao de bibliotecas
#include "mbed.h"
#include "TextLCD.h"
#include "funcoes_ihm.h"
#include "classe.h"
#include <stdio.h>
#include <string>
#define PI 3.14159265

//local para a declaracao de variaveis
float t_motor = 0.002;      //delay entre o acionamento de uma bobina do motor e a outra
float t_teclado = 0.15;     //delay entre a leitura de um botão do teclado, necessário para que um click nao gere mais de uma saída
int hor[] = {12,6,3,9};     //valores que, ao serem convertidos em binário, geram a sequência de acionamento do motor no sentido horário enviando a sequência de 0's e 1's às bobinas
int antihor[] = {3,6,12,9}; //valores que, ao serem convertidos em binário, geram a sequência de acionamento do motor no sentido anti-horário enviando a sequência de 0's e 1's às bobinas
int parado[] = {0,0,0,0};   //valores enviados às bobinas do motor para deixá-lo parado
char tecla;                 //variável que guarda a tecla apertada no teclado
float coord_x = 0;          //variável que guardará a posição linear do eixo x, ela é incrementada com a conta do deslocamento linear dado um deslocamento angular sempre que o eixo é movimentado depois do referencimaneto
float coord_y = 0;          //variável que guardará a posição linear do eixo y, ela é incrementada com a conta do deslocamento linear dado um deslocamento angular sempre que o eixo é movimentado depois do referencimaneto
float coord_z = 0; 
float normal_z = 5;         //variável que guardará a posição linear do eixo z, ela é incrementada com a conta do deslocamento linear dado um deslocamento angular sempre que o eixo é movimentado depois do referencimaneto
int est_x = 0;              //variável que indicará o estado do eixo x, pemitindo ou não que ele possa ser avançado depois de atingir o fim de curso
int est_y = 0;              //variável que indicará o estado do eixo y, pemitindo ou não que ele possa ser avançado depois de atingir o fim de curso
int est_z = 0;              //variável que indicará o estado do eixo z, pemitindo ou não que ele possa ser avançado depois de atingir o fim de curso
float altura_solta = 5;
string est_ihm = "novo";
int cont_pipeta;            //variavel que guarda valores de pipetagens feitas

//pinos usados pelos botoes de fim de curso
InterruptIn fdc_x(PC_10);
InterruptIn fdc_y(PC_11);
InterruptIn fdc_z(PC_12);

//Iterrupcao botao de emergência
InterruptIn interrupcao(PB_11);

//pinos do rele, saida digital para acionar o rele se necessario
//dada uma entrada no pino da emergencia ou um comando de acionamento da pipeta
DigitalOut pipeta(PC_5, 1);
DigitalOut rele2(PB_9, 1);

//botoes para movimentacao eixo a eixo
DigitalIn x_mais(PA_0);
DigitalIn x_menos(PA_1);
DigitalIn y_mais(PC_0);
DigitalIn y_menos(PC_1);
DigitalIn z_mais(PC_2);
DigitalIn z_menos(PC_3);

//pinos do teclado
DigitalIn b(PC_4);
DigitalIn a(PB_0);
DigitalIn t_0(PC_13);
DigitalIn t_1(PB_7);
DigitalIn t_2(PD_2);
DigitalIn t_3(PA_4);
DigitalIn t_4(PB_12);
DigitalIn t_5(PB_15);
DigitalIn t_6(PA_7);
DigitalIn t_7(PB_14);
DigitalIn t_8(PA_6);
DigitalIn t_9(PB_13);

//pinos de saída para os motores
//eixo x
BusOut eixox(PA_15,PA_14,PA_13,PA_12);
//eixo y
BusOut eixoy(PA_11,PA_10,PB_2,PB_1);
//eixo z
BusOut eixoz(PC_9,PC_8,PB_8,PC_6);

//funcao para receber inputs do teclado
char pega_tecla(){
        if (b == 0)return ('A');
        if (a == 0)return('B');
        if (t_0 == 0)return('0');
        if (t_1 == 0)return('1');
        if (t_2 == 0)return('2');
        if (t_3 == 0)return('3');
        if (t_4 == 0)return('4');
        if (t_5 == 0)return('5');
        if (t_6 == 0)return('6');
        if (t_7 == 0)return('7');
        if (t_8 == 0)return('8');
        if (t_9 == 0)return('9');
        return('k'); //caso nenhum botão seja apertado
}
        
//funcoes de fim de curso por interrupção
void lim_x(){
    for(int i = 0; i < 4; i++){TextLCD lcd(D4, D5, D6, D7, D8, D9);
        eixox = parado[i];wait(t_motor);
        lcd.cls();lcd.printf("Limite de x atingido");
        lcd.locate(0,2);lcd.printf("Pressione 0 para continuar");
        est_x = 1;
    }
}

void lim_y(){
    for(int i = 0; i < 4; i++){TextLCD lcd(D4, D5, D6, D7, D8, D9);
    eixoy = parado[i];wait(t_motor);
    lcd.cls();lcd.printf("Limite de y atingido");
    lcd.locate(0,2);lcd.printf("Pressione 0 para continuar");
    est_y = 1;
    }
}

void lim_z(){
    for(int i = 0; i < 4; i++){TextLCD lcd(D4, D5, D6, D7, D8, D9);
    eixoz = parado[i];wait(t_motor);
    lcd.cls();lcd.printf("Limite de z atingido");
    lcd.locate(0,2);lcd.printf("Pressione 0 para continuar");
    est_z = 1;
    }
}

void reseta_eixo(){
    est_x = 0;est_y = 0;est_z = 0;
}

//funcao de movimentacao dos motores
void mov_x_menos(){for(int i = 0; i < 4; i++){eixox = antihor[i];wait(t_motor);coord_x -= (5.625*5/32)/360;}}
void mov_y_menos(){for(int i = 0; i < 4; i++){eixoy = antihor[i];wait(t_motor);coord_y -= (5.625*5/32)/360;est_y = 0;}}
void mov_z_menos(){for(int i = 0; i < 4; i++){eixoz = antihor[i];wait(t_motor);coord_z -= (5.625*5/32)/360;est_z = 0;}}
void mov_x_mais() {for(int i = 0; i < 4; i++){eixox =     hor[i];wait(t_motor);coord_x += (5.625*5/32)/360;}}
void mov_y_mais() {for(int i = 0; i < 4; i++){eixoy =     hor[i];wait(t_motor);coord_y += (5.625*5/32)/360;est_y = 0;}}
void mov_z_mais() {for(int i = 0; i < 4; i++){eixoz =     hor[i];wait(t_motor);coord_z += (5.625*5/32)/360;est_z = 0;}}

//Função para mover um motor de um ponto do plano xy para outro ponto no mesmo plano
void go_to_posicao(float posicao_x, float posicao_y){
    while(coord_x < posicao_x){//ccord_x representa a posicao atual de x e posicao_x é a posicao em x que se quer atingir. 
        mov_x_mais(); //gira no sentido horário
    }  
    while(coord_x > posicao_x){ 
        mov_x_menos(); //gira no sentido anti-horário
    }
    while(coord_y < posicao_y){ //ccord_y representa a posicao atual de y e posicao_y é a posicao em y que se quer atingir. 
        mov_y_mais();  //gira no sentido horário            
    }  
    while(coord_y > posicao_y){ 
        mov_y_menos();   //gira no sentido anti-horário
    };
}

//Calcular a altura do pega com base no tipo do pega
//a dimensão do pega pode ser o lado de um quadrado ou diâmetro de uma circunferência. O contador se refere a quantas vezes o líquido já foi retirado do pega.
float calcula_altura(int forma_do_pega, int dimensao, float v){
    if(forma_do_pega==1){//quad
        return (v-cont_pipeta)/(dimensao*dimensao)*0.001-4;
   }
   else{//red
        return ((v-cont_pipeta)/(PI*(dimensao/2)*(dimensao/2))*0.001-4);
   };
}
void go_to_z(float posicao_z){
    while(coord_z < posicao_z){ //coord_z representa a posicao atual de z e posicao_z é a posicao em z que se quer atingir. 
        mov_z_mais(); //gira no sentido horário         
     }  
     while(coord_z > posicao_z){ 
        mov_z_menos(); //gira no sentido anti-horário 
   }
}
//Funcao da rotina de execucao
void rotina_pino(float volume_solta, int tipo_do_pega, float medida_do_pega, float volume_do_pega, float pos_pino_x, float pos_pino_y, float pos_pega_x, float pos_pega_y){
    for(int i = 0; i < volume_solta; i++){ //
        float altura = calcula_altura(tipo_do_pega,medida_do_pega, volume_do_pega);
        go_to_posicao(pos_pega_x, pos_pega_y); //vai para a posicao pega
        wait(0.5);
        go_to_z(altura); //move z até a altura para sugar o líquido no pega
        wait(0.5);  
        pipeta = 0; //aciona a pipeta pelo relé
        wait(0.5);
        pipeta = 1; //desaciona a pipeta
        wait(0.5);
        go_to_z(normal_z);//move z até a posicao normal de z (posicao de z que não vai atrapalhar o processo de pipetagem)
        go_to_posicao(pos_pino_x,pos_pino_y); //move até o pino pelo plano de x e y
        go_to_z(altura_solta);//Após chegar na posicao xy desejada, a pipeta desce para a altura do solta
        wait(0.5);
        pipeta = 0; //aciona a pipeta e solta o líquido no solta
        wait(0.5);
        pipeta = 1; //desaciona a pipeta
        wait(0.5);
        go_to_z(normal_z);//volta para a posicao normal de z
        cont_pipeta+=1; //contabiliza uma pipetagem
    }
}

//Função que troca de tela
void troca_tela(bool condicao, void telas1(), void telas2(), float valort11, float valort12, float valort21, float valort22, int argumento){
    //telas1 e telas2 são as telas a serem alternadas
    //valort11, 12, 21 e 22 são os valores que vão ser comparados para imprimir um OK no display
    //argumento seria a quantidade de informações pedidas para o usuário
    
    TextLCD lcd(D4, D5, D6, D7, D8, D9); //inicializa o LCD 
    while(condicao){
        telas1();
        if(argumento == 1){
            if(valort11 !=0){ //comparação do valort11
                lcd.locate(18,1);
                lcd.printf("OK");//para caso o usuário tenha inputado um valort11 diferente de 0. A mesma lógica é usada para valort12, 21 e 22. 
            }
        }
        else if(argumento >= 2){
            if(valort11!=0){
                lcd.locate(18,1);lcd.printf("OK");   
            }
            if(valort12 !=0){
                lcd.locate(18,2);lcd.printf("OK");
            }
        }
        wait(2);
        
        //Foi adicionado um refresh de tecla para que o usuário possa escolher um comando apresentado na tela
        tecla = pega_tecla();
        //Caso tecla seja diferente de 'k', as telas param de alternar
        if(tecla!='k'){
            condicao = 0;
        } 
        
        telas2();
        if(argumento == 3){
              if(valort21!=0){
                lcd.locate(18,1);lcd.printf("OK");   
            } 
        }
        else if(argumento == 4){
            if(valort21!=0){
                lcd.locate(18,1);lcd.printf("OK");   
            }
            if(valort22 !=0){
                lcd.locate(18,2);lcd.printf("OK");
            }
        }
        wait(2);
        
        tecla = pega_tecla();
        if(tecla!='k'){
            condicao = 0;
        }  
    };
}

//Funcao de zeramento, chamada assim que a maquina liga e impede que o codigo entre no while(1) enquanto nao for 100% executada.
//Ela aciona os motores ate que o fim de curso seja atingido e pressionado, além de zerar todas as coordenadas dos eixos quando os fins de curso são acionados.
void zeramento(){
    while (fdc_z != 0){for(int i = 0; i < 4; i++){eixoz = hor[i];wait(t_motor);est_z = 1;}}
    while (fdc_x != 0){for(int i = 0; i < 4; i++){eixox = hor[i];wait(t_motor);est_x = 1;}}
    while (fdc_y != 0){for(int i = 0; i < 4; i++){eixoy = hor[i];wait(t_motor);est_y = 1;}}
}

//Variaveis para operacao IHM
using std::string;
string status_tela = "zeramento"; //variavel para guardar o estado atual da tela e situar o programa, juntamente aos botoes apertados, a respeito de onde ele está.
                                  //Neste sentido, ao longo de todo o programa, esta variavel sera usada seguindo a lógica de "se estou na tela x e o usuario apertou o botao
                                  //y, vou para a tela z"
int programa = 0;    //A variável programa remete a que programa salvo o usuário deseja acessar 

//Funcao que será chamada na interrupcao da queda do botao de emergencia
void emergencia(){TextLCD lcd(D4, D5, D6, D7, D8, D9);
    rele2 = 0; //desligamento eletrico dos motores   
    eixox = 0b0000; //desligamento do motor do eixo x a partir do zeramento do estado de todas as suas bobinas
    eixoy = 0b0000; //desligamento do motor do eixo y a partir do zeramento do estado de todas as suas bobinas
    eixoz = 0b0000; //desligamento do motor do eixo z a partir do zeramento do estado de todas as suas bobinas
    
    lcd.cls();lcd.printf("EMERGENCIA ACIONADA"); //aviso da situacao de emergencia da maquina
    lcd.locate(0,1);lcd.printf("Desarme o botao");
    lcd.locate(0,2);lcd.printf("e pressione B para");
    lcd.locate(0,3);lcd.printf("prosseguir");
    
    bool continuar_emergencia = 1;
    while(continuar_emergencia){
        tecla = pega_tecla();
        if(tecla == 'B'){
            continuar_emergencia = 0;
            }
        }
    lcd.cls();
    lcd.printf("Por favor, aceite");
    lcd.locate(0,1);
    lcd.printf("o zeramento do seu");
    lcd.locate(0,2);
    lcd.printf("sistema");
    lcd.locate(0,3);
    lcd.printf("A - proximo");
    continuar_emergencia = 1;
    
    while(continuar_emergencia){
        tecla = pega_tecla();
        if(tecla == 'A'){
            zeramento();
            status_tela = "inicio";
            funcao_inicio();
            continuar_emergencia = 0;
        }}
    wait(1);
}

//Informações sobre o pega a serem armazenadas no array do programa que está sendo construido pelo usuário
//O comprimento de cada array é de 6 pois podem ser "salvos" apenas 6 programas 
float pos_x_pega[6];
float pos_y_pega [6];
float medida_lado_pega[6];
float volume_pega[6];
int tipo_pega[6];
int nome_programa[6];

//parametros que são de confirmação
int confirmacao_vol_solta[6];
int confirmacao_vol_pega[6];
int confirmacao_pos_solta[6];
int confirmacao_pos_pega[6];

//Informações sobre os solta's a serem armazenadas no array do programa que está sendo construido pelo usuário
float dimensao_solta[6];
float volume_solta_1[6];
float volume_solta_2[6];
float volume_solta_3[6];
float volume_solta_4[6];
float volume_solta_5[6];
float volume_solta_6[6];
float volume_solta_7[6];
float volume_solta_8[6];
float volume_solta_9[6];
float pos_x_solta[6];
float pos_y_solta[6];

//Função que coloca OK nas telas de salvo_agree1()
void ok_agree1(){
    TextLCD lcd(D4, D5, D6, D7, D8, D9);
    if(confirmacao_pos_pega[programa] != 0){ 
         lcd.locate(18,1);lcd.printf("OK");   
    }
    if(confirmacao_pos_solta[programa] != 0){
         lcd.locate(18,2);lcd.printf("OK");
    }
}

//Função que coloca OK nas telas de salvo_agree2()
void ok_agree2(){
    TextLCD lcd(D4, D5, D6, D7, D8, D9);
    if(confirmacao_vol_pega[programa] != 0){ //
         lcd.locate(18,1);lcd.printf("OK");   
    }
    if(confirmacao_vol_solta[programa] != 0){
         lcd.locate(18,2);lcd.printf("OK");
    }
}

//main
int main() {
        interrupcao.fall(&emergencia); //faz a leitura de inturrupção logo depois que o botão é pressionado e executa a rotina de emergência
        fdc_x.fall(&lim_x); //faz a leitura de inturrupção do fdc_x logo depois que o botão é pressionado e executa lim_x
        fdc_y.fall(&lim_y); //faz a leitura de inturrupção do fdc_y logo depois que o botão é pressionado e executa lim_y
        fdc_z.fall(&lim_z); //faz a leitura de inturrupção do fdc_z logo depois que o botão é pressionado e executa a lim_z
        fdc_x.rise(&reseta_eixo); //faz a leitura de inturrupção do fdc_x logo depois que o botão é soltado e executa o reseta_eixo
        fdc_y.rise(&reseta_eixo); //faz a leitura de inturrupção do fdc_y logo depois que o botão é soltado e executa o reseta_eixo
        fdc_z.rise(&reseta_eixo); //faz a leitura de inturrupção do fdc_z logo depois que o botão é soltado e executa o reseta_eixo   
        //Variáveis de iteração (serão utilizadas como variável nos cálculos para depois, fornecer o valor para o pega e os soltas)
        int volume; 
        int volume_solta;
        int diametro_solta;
        int diametro;
        int comprimento_quad;
        bool continuar; //condicao de verdade para loops que serão utilizados
        int multiplicador = 10;
        TextLCD lcd(D4, D5, D6, D7, D8, D9); //Pinos para ligar o display à NUCLEO
        lcd.cls();
        //Tela inicial 
        lcd.printf("Bem-vindo ao Pipemax");
        lcd.locate(3,1); //funcao que posiciona o texto na tela
        lcd.printf("o seu sistema");
        lcd.locate(4,2);
        lcd.printf("automatizado");
        lcd.locate(3,3);
        lcd.printf("de pipetagem");
        wait(3);
        lcd.cls(); //funcao que limpa a tela
        
        //tela de espera do zeramento do sistema, enquanto ele não for aceito, a maquina nao pode operar
        lcd.printf("Por favor, aceite");
        lcd.locate(0,1);
        lcd.printf("o zeramento do seu");
        lcd.locate(0,2);
        lcd.printf("sistema");
        lcd.locate(0,3);
        lcd.printf("A - proximo");    
    
    //ピペマックス
    //Loop principal
    while(1) {
        printf("\n ihm: %s",est_ihm);
        rele2 = 1; 
        tecla = pega_tecla();//Variável que guarda o valor da tecla apertada, é chamada diversas vezes ao longo do código
                             //para atualizar o valor mais rapidamente e sempre que necessário       
        
        //Teste para analisar se os valores estão corretos através do monitor serial
        printf("\n tela: %s",status_tela);
        printf("\n%c",tecla);
        //O zeramento só é feito se confirmado apertando a tecla 'A'
        if(tecla == 'A' && status_tela == "zeramento"){
            zeramento();
            status_tela = "inicio";
            funcao_inicio();
        }
    
        tecla = pega_tecla();//Atualiza a variável tecla
        
        //Ações para a tela inicial
        if(tecla == '1' && status_tela == "inicio"){
            est_ihm = "pega";
            continuar = 1; //Condição de funcionamento do loop abaixo
            status_tela = "novo";
            //alternar entre as telas funcao_pega1 e funcao_pega2 (itens 2 e 3 da função) 
            troca_tela(continuar, funcao_pega1, funcao_pega2, medida_lado_pega[programa], volume_pega[programa], pos_y_pega[programa],0,3);
        }

        else if(tecla == '2' && status_tela == "inicio"){   //Ações para a tela inicial quando o usuário seleciona programas salvos
            continuar = 1;
            while(continuar){
                funcao_salvo1();
                if(nome_programa[0] != 0){lcd.locate(2,0);lcd.printf("%d",nome_programa[0]);}
                if(nome_programa[1] != 0){lcd.locate(2,1);lcd.printf("%d",nome_programa[1]);}
                if(nome_programa[2] != 0){lcd.locate(2,2);lcd.printf("%d",nome_programa[2]);}
                wait(2);
                funcao_salvo2();
                if(nome_programa[3] != 0){lcd.locate(2,0);lcd.printf("%d",nome_programa[3]);}
                if(nome_programa[4] != 0){lcd.locate(2,1);lcd.printf("%d",nome_programa[4]);}
                if(nome_programa[5] != 0){lcd.locate(2,2);lcd.printf("%d",nome_programa[5]);}
 
                wait(2);
                tecla = pega_tecla();
                if(tecla!='k'){
                    continuar = 0;
                }
            }
            status_tela = "salvo";
            est_ihm = "salvo";}
    if(est_ihm == "salvo"){
    //Ações para a tela de salvamento
    //A variável programa remete a que programa salvo o usuário deseja acessar 
        tecla = pega_tecla();    
        if(tecla =='1' && status_tela =="salvo"){
            continuar = 1;
            status_tela = "salvo_confirmacao";
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            programa = 0; 
        }
        else if(tecla =='2' && status_tela =="salvo"){
            status_tela = "salvo_confirmacao";
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            programa = 1;
        }
        else if(tecla =='3' && status_tela =="salvo"){
            continuar = 1;
            status_tela = "salvo_confirmacao";
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            programa = 2;
        }
        else if(tecla =='4' && status_tela =="salvo"){
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            programa = 3;
            status_tela = "salvo_confirmacao";}
        else if(tecla =='5' && status_tela =="salvo"){
            continuar = 1;
            status_tela = "salvo_confirmacao";
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            programa = 4;
        }
        else if(tecla =='6' && status_tela =="salvo"){
            continuar = 1;
            status_tela = "salvo_confirmacao";
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            programa = 5;
        }
        else if(tecla =='B' && status_tela =="salvo"){
            status_tela = "inicio";
            continuar = 1;
            funcao_inicio();
        }      
        
        tecla = pega_tecla();//Atualiza a variável tecla
        
        //Ações para a tela de salvo_confirmação
        if(tecla =='1' && status_tela =="salvo_confirmacao"){  
            funcao_salvo_agree_pos_aviso(); //Tela de aviso ao usuário que a pega se deslocará na posição aduequada
            wait(3);
            status_tela = "salvo_confirmacao_pega_agree";
            }
        
        //Ações para a tela salvo_confirmação_pega_agree
        if(tecla == 'A' && status_tela =="salvo_confirmacao_pega_agree"){
            while(coord_x < pos_x_pega[programa]){ //posicionar no local da pega salvo; - se for menor o valor da referencia, gira no sentido horário para aumentar
                mov_x_mais();                
            }  
            while(coord_x > pos_x_pega[programa]){ //posicionar no local da pega salvo; - se for maior o valor da referencia, gira no sentido antihorário para diminuir
                mov_x_menos();    
            }  
            while(coord_y < pos_y_solta[programa]){ //posicionar no local da pega salvo; - se for menor o valor da referencia, gira no sentido horário para aumentar
                mov_y_mais();                
            }  
            while(coord_y > pos_y_solta[programa]){ //posicionar no local da pega salvo; - se for maior o valor da referencia, gira no sentido antihorário para diminuir
                mov_y_menos();    
            }      
            funcao_salvo_agree_pos_certo(); //Tela para o usuário confirmar se é essa a posição de fato da pega 
            status_tela="salvo_pos_certo_pega" ;}
        else if(tecla == 'B' && status_tela=="salvo_confirmacao_pega_agree"){
            continuar = 1;
            status_tela = "salvo_confirmacao";
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            }
        else if(tecla =='2' && status_tela =="salvo_confirmacao"){
             continuar = 1;
             status_tela = "salvo_confirmacao_solta_agree";
             funcao_salvo_agree_solta_aviso();   //posicionar no local de solta para confirmação; (motor -> programa.pos_x_solta e motor -> programa.pos_y_solta)
             wait(3);
            }
        
        //Ações para a tela confirmação_solta_agree
        if(tecla == 'A' && status_tela =="salvo_confirmacao_solta_agree"){  
             while(coord_x < pos_x_solta[programa]){ //posicionar no local da pega salvo; - se for menor o valor da referencia, gira no sentido horário para aumentar
                mov_x_mais();                
             }  
             while(coord_x > pos_x_solta[programa]){ //posicionar no local da pega salvo; - se for maior o valor da referencia, gira no sentido antihorário para diminuir
                mov_x_menos();    
             }   
             while(coord_y < pos_y_solta[programa]){ //posicionar no local da pega salvo; - se for menor o valor da referencia, gira no sentido horário para aumentar
                mov_y_mais();                
             }  
             while(coord_y > pos_y_solta[programa]){ //posicionar no local da pega salvo; - se for maior o valor da referencia, gira no sentido antihorário para diminuir
                mov_y_menos();    
             }     
             funcao_salvo_agree_pos_certo();
             status_tela = "salvo_pos_certo_solta";}            
        else if(tecla == 'B' && status_tela=="salvo_confirmacao_solta_agree"){
            funcao_salvo1();
            if(nome_programa[0] != 0){lcd.locate(2,0);lcd.printf("%d",nome_programa[0]);}
            if(nome_programa[1] != 0){lcd.locate(2,1);lcd.printf("%d",nome_programa[1]);}
            if(nome_programa[2] != 0){lcd.locate(2,2);lcd.printf("%d",nome_programa[2]);}
            wait(1);
            funcao_salvo2();
            if(nome_programa[3] != 0){lcd.locate(2,0);lcd.printf("%d",nome_programa[3]);}
            if(nome_programa[4] != 0){lcd.locate(2,1);lcd.printf("%d",nome_programa[4]);}
            if(nome_programa[5] != 0){lcd.locate(2,2);lcd.printf("%d",nome_programa[5]);}
             status_tela = "salvo";}     
        else if(tecla =='3' && status_tela =="salvo_confirmacao"){
             funcao_salvo_agree_pega_vol();   //Função que imprime na tela do usuário que ele deve dar entreda no volume
             continuar = 1;
             multiplicador = 10;
             lcd.locate(6,1); 
            while(continuar){ // Pega o valor imputado pelo usuário
                printf("\n%c",pega_tecla()); 
                tecla = pega_tecla();
                wait(t_teclado);
                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                    volume = multiplicador*volume + ((int)tecla-48); //  
                    lcd.printf("%c", tecla);
                }
                else if(tecla == 'A'){
                    volume_pega[programa]=volume;  //recebe o valor que o usuário colocou no volume.
                    lcd.locate(0,2);
                    printf("Volume inputado!");
                    continuar = 0;
                    confirmacao_vol_pega[programa]=1;
                    wait(1);
                }
            }                                 
            status_tela="salvo_conf_vol_pega";}     
        else if(tecla =='4' && status_tela =="salvo_confirmacao"){
             funcao_salvo_agree_solta_vol();  //volumes configurados por cada pipeta. (programa.vol_solta_pipeta)
             lcd.locate(2,0);lcd.printf("%.f",volume_solta_1[programa]);
             lcd.locate(9,0);lcd.printf("%.f",volume_solta_2[programa]);
             lcd.locate(17,0);lcd.printf("%.f",volume_solta_3[programa]);
             
             lcd.locate(2,1);lcd.printf("%.f",volume_solta_4[programa]);
             lcd.locate(9,1);lcd.printf("%.f",volume_solta_5[programa]);
             lcd.locate(17,1);lcd.printf("%.f",volume_solta_6[programa]);
             
             lcd.locate(2,2);lcd.printf("%.f",volume_solta_7[programa]);
             lcd.locate(8,2);lcd.printf("%.f",volume_solta_8[programa]);
             lcd.locate(17,2);lcd.printf("%.f",volume_solta_9[programa]);                     
             status_tela="salvo_conf_vol_solta";}
        else if(tecla =='B' && status_tela =="salvo_confirmacao"){ 
            funcao_salvo1();
            if(nome_programa[0] != 0){lcd.locate(2,0);lcd.printf("%d",nome_programa[0]);}
            if(nome_programa[1] != 0){lcd.locate(2,1);lcd.printf("%d",nome_programa[1]);}
            if(nome_programa[2] != 0){lcd.locate(2,2);lcd.printf("%d",nome_programa[2]);}

            wait(1);
            funcao_salvo2();
            if(nome_programa[3] != 0){lcd.locate(2,0);lcd.printf("%d",nome_programa[3]);}
            if(nome_programa[4] != 0){lcd.locate(2,1);lcd.printf("%d",nome_programa[4]);}
            if(nome_programa[5] != 0){lcd.locate(2,2);lcd.printf("%d",nome_programa[5]);}
             status_tela = "salvo";}   
        
        tecla = pega_tecla(); //Atualiza a variável tecla
        
        //Ações para a tela de salvo_pos_certo_pega
        if(tecla =='1' && status_tela =="salvo_pos_certo_pega"){
            confirmacao_pos_pega[programa]=1;
            status_tela = "salvo_confirmacao";
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            }//salva essa posição como correta
        else if(tecla =='2' && status_tela =="salvo_pos_certo_pega"){ //Caso o usuário queria ajustar o posicionamento
            lcd.cls();
            funcao_pega_pos_x();
            lcd.printf("Ponha a pega em  x/y ");
            lcd.locate(0,3);
            lcd.printf("      B-Voltar      ");
            continuar = 1; //Inicia o loop de posicionamento
            while(continuar){
                 tecla = pega_tecla(); // pegla a tecla apertada pelo usuário para sair do loop
                 if(x_menos == 0){mov_x_menos(); // Movimenta o eixo conforme o botão selecionado
                    lcd.cls();      
                    lcd.printf("X: %4.1f", coord_x);}  //Printa para o usuário isso
                 else if(x_mais == 0){mov_x_mais();   // Movimenta o eixo conforme o botão selecionado
                    lcd.cls();
                    lcd.printf("X: %4.1f", coord_x);}  //Printa para o usuário isso
                else if(y_menos == 0){mov_y_menos();  //Movimenta o eixo conforme o botão selecionado
                    lcd.cls();      
                    lcd.printf("Y: %4.1f", coord_y);} //Printa para o usuário isso
                else if(y_mais == 0){mov_y_mais(); // Movimenta o eixo conforme o botão selecionado
                    lcd.cls();      
                    lcd.printf("Y: %4.1f", coord_y);} //Printa para o usuário isso
                if(tecla=='A'){
                    pos_x_pega[programa] = coord_x;
                    pos_y_pega[programa] = coord_y;
                    lcd.cls();
                    lcd.printf("Posicao de x e y salva!");
                    lcd.locate(0,1);
                    lcd.printf("Posicao X: %4.1f", coord_x);
                    lcd.locate(0,2);
                    lcd.printf("Posicao Y: %4.1f", coord_y);
                    status_tela = "salvo_confirmacao";
                    confirmacao_pos_pega[programa]=1;
                    troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
                }
            }
        }
        else if(tecla =='B' && status_tela =="salvo_pos_certo_pega"){             
            status_tela = "salvo_confirmacao";
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
        }  
        
        
        //Ações para a tela salvo_conf_vol_pega
        if(tecla =='A' && status_tela =="salvo_conf_vol_pega"){
            confirmacao_vol_pega[programa]=1;
            status_tela = "salvo_confirmacao";
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            }//salva essa posição como correta
        else if(tecla =='B' && status_tela =="salvo_conf_vol_pega"){             
            status_tela = "salvo_confirmacao";
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            }  
        
        //Ações para a tela de salvo_pos_certo_solta
        if(tecla =='1' && status_tela =="salvo_pos_certo_solta"){
            confirmacao_pos_solta[programa] = 1; //Tag que indica que o usuário confirmou a posição salva
            status_tela = "salvo_confirmacao";
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
            }//salva essa posição como correta
        else if(tecla =='2' && status_tela =="salvo_pos_certo_solta"){
            lcd.cls();
            funcao_solta_pos_x();
            lcd.printf("Ponha a pega em x/y ");
            lcd.locate(0,3);
            lcd.printf("      B-Voltar      ");
            continuar = 1; //Inicia o loop de posicionamento
            while(continuar){
                 tecla = pega_tecla(); // pegla a tecla apertada pelo usuário para sair do loop
                 if(x_menos == 0){mov_x_menos(); // Movimenta o eixo conforme o botão selecionado
                    lcd.cls();      
                    lcd.printf("X: %4.1f", coord_x);}  //Printa para o usuário isso
                 else if(x_mais == 0){mov_x_mais();   // Movimenta o eixo conforme o botão selecionado
                    lcd.cls();
                    lcd.printf("X: %4.1f", coord_x);}  //Printa para o usuário isso
                else if(y_menos == 0){mov_y_menos();  //Movimenta o eixo conforme o botão selecionado
                    lcd.cls();      
                    lcd.printf("Y: %4.1f", coord_y);} //Printa para o usuário isso
                else if(y_mais == 0){mov_y_mais(); // Movimenta o eixo conforme o botão selecionado
                    lcd.cls();      
                    lcd.printf("Y: %4.1f", coord_y);} //Printa para o usuário isso
                if(tecla=='A'){
                    pos_x_solta[programa] = coord_x;
                    pos_y_solta[programa] = coord_y;
                    lcd.cls();
                    lcd.printf("Posicao de x e y salva!");
                    lcd.locate(0,1);
                    lcd.printf("Posicao X: %4.1f", coord_x);
                    lcd.locate(0,2);
                    lcd.printf("Posicao Y: %4.1f", coord_y);
                    status_tela = "salvo_confirmacao";
                    confirmacao_pos_solta[programa]=1; //Flag que mostra que o usuário setou a posição conforme ele queria e está confirmado.
                    troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);
                    continuar = 0;
                }
            }
        }
        else if(tecla =='B' && status_tela =="salvo_pos_certo_solta"){             
            status_tela = "salvo_confirmacao";
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);}      
        
        //Ações para a tela salvo_conf_vol_solta
        if(tecla =='A' && status_tela =="salvo_conf_vol_solta"){
            confirmacao_vol_solta[programa]=1; 
            status_tela = "salvo_confirmacao";   
            continuar = 1;
            troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa],confirmacao_vol_pega[programa],confirmacao_vol_solta[programa],4);     
            }//salva essa posição como correta
        else if(tecla =='B' && status_tela =="salvo_conf_vol_solta"){
            funcao_salvo_vol_solta_modifica();
            wait(5);
            funcao_salvo_agree_solta_vol();
             lcd.locate(2,0);lcd.printf("%.f",volume_solta_1[programa]);
             lcd.locate(9,0);lcd.printf("%.f",volume_solta_2[programa]);
             lcd.locate(17,0);lcd.printf("%.f",volume_solta_3[programa]);
             
             lcd.locate(2,1);lcd.printf("%.f",volume_solta_4[programa]);
             lcd.locate(9,1);lcd.printf("%.f",volume_solta_5[programa]);
             lcd.locate(17,1);lcd.printf("%.f",volume_solta_6[programa]);
             
             lcd.locate(2,2);lcd.printf("%.f",volume_solta_7[programa]);
             lcd.locate(9,2);lcd.printf("%.f",volume_solta_8[programa]);
             lcd.locate(17,2);lcd.printf("%.f",volume_solta_9[programa]);
             bool cleber = 1;
            while(cleber){
                tecla = pega_tecla();
                wait(t_teclado);
                if(tecla != 'A'){
                if(tecla == '1' && status_tela=="salvo_conf_vol_solta"){
                     printf("entrou if 1 salvo_conf");
                     volume = 0;
                     continuar = 1;
                     lcd.locate(2,0);
                     while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100)
                            {
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(2,0);}
                        }
                        else if(tecla == 'A'){
                            tecla = 'k';
                            continuar = 0;
                            volume_solta_1[programa]=volume;
                        }
                    }
                }
                else if(tecla=='2' && status_tela=="salvo_conf_vol_solta"){
                     volume = 0;
                     continuar = 1;
                     multiplicador = 10;
                     lcd.locate(9,0); 
                    while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100){
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(9,0);}
                            }
                        else if(tecla == 'A'){
                            continuar = 0;
                            volume_solta_2[programa]=volume;
                        }
                    }
                }
                else if(tecla=='3' && status_tela=="salvo_conf_vol_solta"){
                     volume = 0;
                     continuar = 1;
                     multiplicador = 10;
                     lcd.locate(17,0); 
                    while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100){
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(17,0);}
                            }
                        else if(tecla == 'A'){
                            continuar = 0;
                            volume_solta_3[programa]=volume;
                        }
                    }
                }
                else if(tecla=='4' && status_tela=="salvo_conf_vol_solta"){
                     volume = 0;
                     continuar = 1;
                     multiplicador = 10;
                     lcd.locate(2,1); 
                    while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100){
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(2,1);}
                            }
                        else if(tecla == 'A'){
                            continuar = 0;
                            volume_solta_4[programa]=volume;
                        }
                    }
                }
                else if(tecla=='5' && status_tela=="salvo_conf_vol_solta"){
                     volume = 0;
                     continuar = 1;
                     multiplicador = 10;
                     lcd.locate(9,1); 
                    while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100){
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(9,1);}
                            }
                        else if(tecla == 'A'){
                            continuar = 0;
                            volume_solta_5[programa]=volume;
                        }
                    }
                }
                else if(tecla=='6' && status_tela=="salvo_conf_vol_solta"){
                     volume = 0;
                     continuar = 1;
                     multiplicador = 10;
                     lcd.locate(17,1); 
                    while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100){
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(17,1);}
                            }
                        else if(tecla == 'A'){
                             continuar = 0;
                             volume_solta_6[programa]=volume;
                            }
                        }
                    }
                else if(tecla=='7' && status_tela=="salvo_conf_vol_solta"){
                     volume = 0;
                     continuar = 1;
                     multiplicador = 10;
                     lcd.locate(2,2); 
                    while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100){
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(2,2);}
                            }
                        else if(tecla == 'A'){
                            continuar = 0;
                            volume_solta_7[programa]=volume;
                        }
                    }
                }
                else if(tecla=='8' && status_tela=="salvo_conf_vol_solta"){
                     volume = 0;
                     continuar = 1;
                     multiplicador = 10;
                     lcd.locate(9,2); 
                    while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100){
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(9,2);}
                            }
                        else if(tecla == 'A'){
                            continuar = 0;
                            volume_solta_8[programa]=volume;
                        }
                    }
                }
                else if(tecla=='9' && status_tela=="salvo_conf_vol_solta"){
                     volume = 0;
                     continuar = 1;
                     multiplicador = 10;
                     lcd.locate(17,2); 
                    while(continuar){ // Pega o valor imputado pelo usuário
                        printf("\n%c",pega_tecla()); 
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            if(volume*10 < 100){
                                volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                lcd.printf("%c", tecla);
                            }
                            else{
                            volume = 0;
                            lcd.locate(17,2);}
                            }
                        else if(tecla == 'A'){
                            continuar = 0;
                            volume_solta_9[programa]=volume;
                        }
                    }
                }
                else if(tecla == 'B' && status_tela == "salvo_conf_vol_solta"){
                    status_tela = "salvo_confirmacao";
                    continuar = 1;
                    troca_tela(continuar, funcao_salvo_agree1, funcao_salvo_agree2, confirmacao_pos_pega[programa], confirmacao_pos_solta[programa], confirmacao_vol_pega[programa], confirmacao_vol_solta[programa], 4);
                    cleber = 0;}
                }//fim do if (tecla !=A)
                else if(tecla == 'A'){
                    printf("\nfalou clebao");
                    cleber = 0;}
                }//fim do while(cleber)
                confirmacao_vol_solta[programa]=1;}//fim do else if(tecla =='B' && status_tela =="salvo_conf_vol_solta")
        tecla = pega_tecla(); 

        if(confirmacao_vol_solta[programa]==1 && confirmacao_vol_pega[programa]==1 && confirmacao_pos_pega[programa]==1 && confirmacao_pos_solta[programa]==1){
            funcao_acomp();
            status_tela="acompanhamento";
            est_ihm = "exec";
            confirmacao_pos_pega[programa]=0;
            confirmacao_pos_solta[programa]=0;
            confirmacao_vol_pega[programa]=0;
            confirmacao_pos_solta[programa]=0;}
        } //fim if(est_ihm)
        
        if(est_ihm == "pega"){
            
            //Ações para a tela novo
            if(tecla =='1' && status_tela =="novo"){
                funcao_pega_forma();
                status_tela ="forma";
            }
        
            else if(tecla =='2' && status_tela == "novo"){
                volume = 0;
                printf("\n%c",pega_tecla());
                funcao_pega_volume(); // Função que permite a entreda do valor de volume pelo usuário
                status_tela = "volume";
                continuar = 1;
                lcd.locate(6,1);
                while(continuar){
                    printf("\n%c",pega_tecla()); 
                    tecla = pega_tecla();
                    wait(t_teclado);
                    if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                        volume = multiplicador*volume + ((int)tecla-48);    
                        lcd.printf("%c", tecla);
                    }
                    else if(tecla == 'A'){
                        volume_pega[programa] = volume;
                        lcd.locate(0,2);
                        printf("Volume inputado!");
                        continuar = 0;
                        wait(1);
                    }
                    else if(tecla=='B'){
                        funcao_pega1();
                        if(medida_lado_pega !=0){
                            lcd.locate(18,1);lcd.printf("OK");   
                        }
                        if(volume_pega !=0){
                            lcd.locate(18,2);lcd.printf("OK");
                        }
                        wait(1);
                        funcao_pega2();
                        if(pos_y_pega[programa] !=0){
                            lcd.locate(18,1);lcd.printf("OK");    
                        }
                        status_tela = "novo";
                        continuar = 0;
                    }
                }   
            }
            else if(tecla == '3' && status_tela == "novo"){
                funcao_pega_pos_x();
                status_tela = "pos_x";
                continuar = 1;
                 while(continuar){
                        tecla = pega_tecla();
                     if(x_menos == 0){mov_x_menos();
                        lcd.cls();      
                        lcd.printf("X: %4.1f", coord_x);}
                     else if(x_mais == 0){mov_x_mais();
                        lcd.cls();
                        lcd.printf("X: %4.1f", coord_x);}
                    if(tecla=='A'){
                        pos_x_pega[programa] = coord_x;
                        continuar = 0;
                        printf("Posicao de y salva!");
                        printf("Posicao X: %4.1f", coord_x);
                    }
                }
            }
            else if(tecla == 'B' && status_tela == "novo"){
                funcao_inicio();
                status_tela = "inicio";
            }
            else if(tecla == '1' && status_tela == "salvo"){
                funcao_salvo_agree1();
                ok_agree1();
                status_tela = "confirmacao";
            }
            else if(tecla =='2' && status_tela == "salvo"){
                funcao_salvo_agree1();
                ok_agree1();
                status_tela = "confirmacao";
            }
            else if(tecla =='B' && status_tela == "salvo"){
                funcao_inicio();
                status_tela = "inicio";
            }
                
            wait(t_teclado);
            tecla = pega_tecla();    
            
            //Ações para a tela forma (para definir o formato do recipiente de pega)
            if(tecla == '1' && status_tela == "forma"){
                wait(0.5);
                funcao_pega_forma_quad();
                tipo_pega[programa] =1;
                tecla = pega_tecla();
                wait(t_teclado);
                status_tela ="forma_quad";
                continuar = 1;
                comprimento_quad = 0;
                lcd.locate(0,2);
                while(continuar){
                    printf("\n%c",pega_tecla()); 
                    tecla = pega_tecla();
                    wait(t_teclado);
                    if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                        comprimento_quad = multiplicador*comprimento_quad + ((int)tecla - 48);
                        lcd.printf("%c",tecla);
                    }
                    else if(tecla == 'A'){
                        continuar = 0;
                        medida_lado_pega[programa] = comprimento_quad;
                        printf("Comprimento inputado!");
                        printf("\nComprimento: %d", comprimento_quad);
                    }
                    else if(tecla=='B'){
                        funcao_pega_forma();
                        status_tela = "forma";
                        continuar = 0;
                    }
                }
            }
            else if(tecla == '2' && status_tela == "forma"){
                funcao_pega_forma_red();
                tipo_pega[programa] = 2;
                tecla = pega_tecla();
                wait(t_teclado);
                continuar = 1;
                diametro = 0;
                status_tela = "forma_red";
                lcd.locate(0,2);
                while(continuar){
                    tecla = pega_tecla();
                    wait(t_teclado);
                    if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                        diametro = multiplicador*diametro + ((int)tecla - 48);
                        lcd.printf("%c",tecla);
                    }
                    else if(tecla == 'A'){
                        continuar = 0;
                        medida_lado_pega[programa] = diametro;
                        printf("Diametro inputado!");
                        printf("Diametro: %d", diametro);
                    }
                    else if(tecla=='B'){
                        funcao_pega_forma();
                        status_tela = "forma";
                        continuar = 0;
                    }
                }
            }
            else if(tecla == 'B' && status_tela == "forma"){
                status_tela = "novo";
                continuar = 1;
                troca_tela(continuar, funcao_pega1, funcao_pega2, medida_lado_pega[programa], volume_pega[programa], pos_y_pega[programa],0,3);
            }
            
            tecla = pega_tecla();
            
            //Ações para a tela forma_quad, para detalhes sobre o formato quadrado
            if(tecla == 'A' && status_tela == "forma_quad"){
                status_tela ="novo";
                continuar = 1;
                troca_tela(continuar, funcao_pega1, funcao_pega2, medida_lado_pega[programa], volume_pega[programa], pos_y_pega[programa],0,3);
            }
            else if(tecla == 'B' && status_tela == "forma_quad"){
                funcao_pega_forma();
                status_tela = "forma";
            }
            else if(tecla == 'A' && status_tela == "forma_red"){
                continuar = 1;
                status_tela ="novo";
                troca_tela(continuar, funcao_pega1, funcao_pega2, medida_lado_pega[programa], volume_pega[programa], pos_y_pega[programa],0,3);
            }
            else if(tecla == 'B' && status_tela == "forma_red"){
                funcao_pega_forma();
                status_tela = "forma";
            }
            else if(tecla == 'A' && status_tela == "volume"){
                volume_pega[programa] = 12;
                status_tela ="novo";
                continuar = 1;
                troca_tela(continuar, funcao_pega1, funcao_pega2, medida_lado_pega[programa], volume_pega[programa], pos_y_pega[programa],0,3);
            }
            else if( tecla == 'B' && status_tela == "volume"){
                funcao_pega_forma();
                status_tela = "forma";
            }
            else if(tecla == 'A' && status_tela == "pos_x"){ //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                funcao_pega_pos_y();  //colocar programacao que contem o posicionamento do eixo y
                status_tela = "pos_y";
                continuar = 1;
                wait(1);
                 while(continuar){
                        tecla = pega_tecla();
                     if(y_menos == 0){mov_y_menos();
                        lcd.cls();      
                        lcd.printf("Y: %4.1f", coord_y);
                    }
                     else if(y_mais == 0){mov_y_mais();
                        lcd.cls();
                        lcd.printf("Y: %4.1f", coord_y);
                    }
                    if(tecla=='A'){
                        pos_y_pega[programa] = coord_y;
                        printf("Posicao de y salva!");
                        printf("Posicao Y: %4.1f", coord_y);
                        continuar = 0;
                    }
                }
            }
            else if(tecla == 'B' && status_tela == "pos_x"){ ///!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                status_tela = "novo";
                continuar = 1;
                troca_tela(continuar, funcao_pega1, funcao_pega2, medida_lado_pega[programa], volume_pega[programa], pos_y_pega[programa],0,3);
            }
                
            tecla = pega_tecla();
    //        wait(t_teclado);
            
            //Ações para a tela pos_y
            if(tecla == 'A' && status_tela == "pos_y"){
                status_tela ="novo";
                continuar = 1;
                troca_tela(continuar, funcao_pega1, funcao_pega2, medida_lado_pega[programa], volume_pega[programa], pos_y_pega[programa],0,3);
            }
            else if(tecla == 'B' && status_tela == "pos_y"){
                funcao_pega_pos_x();
                status_tela = "pos_x";
                continuar = 1;
                while(continuar){
                        tecla = pega_tecla();
                    if(x_menos == 0){mov_x_menos();
                        lcd.cls();      
                        lcd.printf("X: %4.1f", coord_x);
                    }
                    else if(x_mais == 0){mov_x_mais();
                        lcd.cls();
                        lcd.printf("X: %4.1f", coord_x);
                    }
                    if(tecla=='A'){
                        continuar = 0;
                        printf("Posicao de x salva!");
                        printf("Posicao X: %4.1f", coord_x);
                    }
                }
            } 
            if(pos_x_pega[programa]!=0 && pos_y_pega[programa]!=0 && medida_lado_pega[programa]!=0 && volume_pega[programa] !=0 && tipo_pega[programa]!=0 && status_tela == "novo"){
                status_tela="solta";
                est_ihm = "solta";
                continuar = 1;
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
            }
        }//fim if(est_ihm == "pega")
                    
        if(est_ihm == "solta"){
            
            //Ações para a tela "solta", para definir informações sobre os solta's
            if(tecla == '1' && status_tela == "solta"){
                funcao_solta_dimensao();
                continuar = 1;
                diametro_solta = 0;
                status_tela="solta_dimensao";
                lcd.locate(0,2);
                while(continuar){
                    tecla = pega_tecla();
                    wait(t_teclado);
                    if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                        diametro_solta = multiplicador*diametro_solta + ((int)tecla - 48);
                        lcd.printf("%c",tecla);
                    }
                    else if(tecla == 'A'){
                        printf("Diametro do solta inputado!");
                        printf("Diametro do solta: %d", diametro_solta);
                        continuar = 0;
                    }
                    else if(tecla=='B'){
                        funcao_pega_forma();
                        status_tela = "solta";
                        continuar = 1;
                        troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
                    }
                }
            }
            
            else if(tecla == '2' && status_tela == "solta"){
                 printf("fantasminha camarada");
                 status_tela="solta_vol";
                 funcao_solta_vol();
                 wait(0.5);
            }
            else if(tecla == '3' && status_tela == "solta"){
                funcao_solta_pos_x();
                status_tela="solta_pos_x";
                continuar = 1;
                while(continuar){
                        tecla = pega_tecla();
                    if(x_menos == 0){mov_x_menos();
                        lcd.cls();      
                        lcd.printf("X: %4.1f", coord_x);
                    }
                    else if(x_mais == 0){mov_x_mais();
                        lcd.cls();
                        lcd.printf("X: %4.1f", coord_x);
                    }
                    if(tecla=='A'){
                        pos_x_solta[programa] = coord_x;
                        continuar = 0;
                        printf("Posicao de x salva!");
                        printf("Posicao X: %4.1f", coord_x);
                    }
                }
            }   
            else if(tecla == 'B' && status_tela == "solta"){
                est_ihm = "pega";
                continuar = 1;
                status_tela="novo";
                troca_tela(continuar, funcao_pega1, funcao_pega2, medida_lado_pega[programa],volume_pega[programa], pos_y_pega[programa],0,3);
            }
            
            tecla = pega_tecla();
            if(tecla == '1' && status_tela == "solta_vol"){
                volume_solta = 0;
                funcao_solta_vol_igual();
                status_tela = "solta_vol_igual";
                lcd.locate(0,2);
                continuar = 1;
                while(continuar){
                    tecla = pega_tecla();
                    wait(t_teclado);
                    if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                        volume_solta = multiplicador*volume_solta + ((int)tecla - 48);
                        lcd.printf("%c",tecla);
                    }
                    else if(tecla == 'A'){
                        printf("Volume solta inputado!");
                        printf("Volume: %d", volume_solta);
                        volume_solta_1[programa]=volume_solta;
                        volume_solta_2[programa]=volume_solta;
                        volume_solta_3[programa]=volume_solta;
                        volume_solta_4[programa]=volume_solta;
                        volume_solta_5[programa]=volume_solta;
                        volume_solta_6[programa]=volume_solta;
                        volume_solta_7[programa]=volume_solta;
                        volume_solta_8[programa]=volume_solta;
                        volume_solta_9[programa]=volume_solta;
                        continuar = 0;
                    }
                    else if(tecla=='B'){
                        funcao_solta_vol();
                        status_tela = "solta";
                        continuar = 0;
                    }
                }
            }
            
            else if(tecla=='2' && status_tela=="solta_vol"){
                funcao_solta_vol_cada();
                 lcd.locate(11,0);lcd.printf("%.f",volume_solta_1[programa]);
                 lcd.locate(14,0);lcd.printf("%.f",volume_solta_2[programa]);
                 lcd.locate(17,0);lcd.printf("%.f",volume_solta_3[programa]);
                 
                 lcd.locate(11,1);lcd.printf("%.f",volume_solta_4[programa]);
                 lcd.locate(14,1);lcd.printf("%.f",volume_solta_5[programa]);
                 lcd.locate(17,1);lcd.printf("%.f",volume_solta_6[programa]);
                 
                 lcd.locate(11,2);lcd.printf("%.f",volume_solta_7[programa]);
                 lcd.locate(14,2);lcd.printf("%.f",volume_solta_8[programa]);
                 lcd.locate(17,2);lcd.printf("%.f",volume_solta_9[programa]);
                status_tela="solta_vol_dif";
            }
            else if(tecla=='B' && status_tela=="solta_vol"){
                status_tela="solta";  
                continuar = 1;
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
            }
            
            tecla=pega_tecla();
            //Ações para a tela solta_dimensao, para definir informações sobre a dimensão do solta
            if(tecla=='A' && status_tela=="solta_dimensao"){
                dimensao_solta[programa] = 10;
                continuar = 1;
                status_tela="solta";   
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
            }
            else if(tecla=='B' && status_tela=="solta_dimensao"){
                continuar = 1;
                status_tela="solta"; 
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);    
            }

            if(tecla=='A' && status_tela=="solta_pos_x"){
                funcao_solta_pos_y();
                status_tela="solta_pos_y";
                continuar = 1;
                wait(1);
                 while(continuar){
                        tecla = pega_tecla();
                    if(y_menos == 0){mov_y_menos();
                        lcd.cls();      
                        lcd.printf("Y: %4.1f", coord_y);
                    }
                    else if(y_mais == 0){mov_y_mais();
                        lcd.cls();
                        lcd.printf("Y: %4.1f", coord_y);
                    }
                    if(tecla=='A'){
                        pos_y_solta[programa] = coord_y;
                        printf("Posicao de y salva!");
                        printf("Posicao Y: %4.1f", coord_y);
                        continuar = 0;
                    }
                }
            }
            
            else if(tecla=='B' && status_tela=="solta_pos_x"){
                status_tela="solta";  
                continuar = 1;
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
            }  
                
            tecla=pega_tecla();
            if(tecla=='A' && status_tela=="solta_vol_igual"){
                status_tela="solta";
                continuar = 1;
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
            }
            
            else if(tecla=='B' && status_tela=="solta_vol_igual"){
                funcao_solta_vol();
                status_tela="solta_vol";
            }
    
            if(tecla=='A' && status_tela=="solta_vol_dif"){
                status_tela="solta";
                continuar = 1;
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3); 
            }
            else if(tecla =='B' && status_tela =="solta_vol_dif"){
                funcao_salvo_vol_solta_modifica();
                wait(5);
                funcao_salvo_agree_solta_vol();
                lcd.locate(2,0);lcd.printf("%d",volume_solta_1[programa]);
                lcd.locate(9,0);lcd.printf("%d",volume_solta_2[programa]);
                lcd.locate(17,0);lcd.printf("%d",volume_solta_3[programa]);
             
                lcd.locate(2,1);lcd.printf("%d",volume_solta_4[programa]);
                lcd.locate(9,1);lcd.printf("%d",volume_solta_5[programa]);
                lcd.locate(17,1);lcd.printf("%d",volume_solta_6[programa]);
             
                lcd.locate(2,2);lcd.printf("%d",volume_solta_7[programa]);
                lcd.locate(9,2);lcd.printf("%d",volume_solta_8[programa]);
                lcd.locate(17,2);lcd.printf("%d",volume_solta_9[programa]);
                 
                bool cleber = 1;
                while(cleber){
                    tecla = pega_tecla();
                    wait(t_teclado);
                    if(tecla != 'A'){
                        if(tecla == '1' && status_tela=="solta_vol_dif"){
                             printf("entrou if 1 salvo_conf");
                             volume = 0;
                             continuar = 1;
                             lcd.locate(2,0);
                             while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100)
                                    {
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(2,0);
                                    }
                                }
                                else if(tecla == 'A'){
                                    tecla = 'k';
                                    continuar = 0;
                                    volume_solta_1[programa]=volume;
                                }
                            }
                        }
                        else if(tecla=='2' && status_tela=="solta_vol_dif"){
                             volume = 0;
                             continuar = 1;
                             multiplicador = 10;
                             lcd.locate(9,0); 
                            while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100){
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(9,0);}
                                    }
                                else if(tecla == 'A'){
                                    continuar = 0;
                                    volume_solta_2[programa]=volume;
                                }
                            }
                        }
                        else if(tecla=='3' && status_tela=="solta_vol_dif"){
                             volume = 0;
                             continuar = 1;
                             multiplicador = 10;
                             lcd.locate(17,0); 
                            while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100){
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(17,0);}
                                    }
                                else if(tecla == 'A'){
                                    continuar = 0;
                                    volume_solta_3[programa]=volume;
                                }
                            }
                        }
                        else if(tecla=='4' && status_tela=="solta_vol_dif"){
                             volume = 0;
                             continuar = 1;
                             multiplicador = 10;
                             lcd.locate(2,1); 
                            while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100){
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(2,1);}
                                    }
                                else if(tecla == 'A'){
                                    continuar = 0;
                                    volume_solta_4[programa]=volume;
                                }
                            }
                        }
                        else if(tecla=='5' && status_tela=="solta_vol_dif"){
                             volume = 0;
                             continuar = 1;
                             multiplicador = 10;
                             lcd.locate(9,1); 
                            while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100){
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(9,1);}
                                    }
                                else if(tecla == 'A'){
                                    continuar = 0;
                                    volume_solta_5[programa]=volume;
                                }
                            }
                        }
                        else if(tecla=='6' && status_tela=="solta_vol_dif"){
                             volume = 0;
                             continuar = 1;
                             multiplicador = 10;
                             lcd.locate(17,1); 
                            while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100){
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(17,1);}
                                    }
                                else if(tecla == 'A'){
                                     continuar = 0;
                                     volume_solta_6[programa]=volume;
                                    }
                                }
                            }
                        else if(tecla=='7' && status_tela=="solta_vol_dif"){
                             volume = 0;
                             continuar = 1;
                             multiplicador = 10;
                             lcd.locate(2,2); 
                            while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100){
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(2,2);}
                                    }
                                else if(tecla == 'A'){
                                    continuar = 0;
                                    volume_solta_7[programa]=volume;
                                }
                            }
                        }
                        else if(tecla=='8' && status_tela=="solta_vol_dif"){
                             volume = 0;
                             continuar = 1;
                             multiplicador = 10;
                             lcd.locate(9,2); 
                            while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100){
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(9,2);}
                                    }
                                else if(tecla == 'A'){
                                    continuar = 0;
                                    volume_solta_8[programa]=volume;
                                }
                            }
                        }
                        else if(tecla=='9' && status_tela=="solta_vol_dif"){
                             volume = 0;
                             continuar = 1;
                             multiplicador = 10;
                             lcd.locate(17,2); 
                            while(continuar){ // Pega o valor imputado pelo usuário
                                printf("\n%c",pega_tecla()); 
                                tecla = pega_tecla();
                                wait(t_teclado);
                                if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                                    if(volume*10 < 100){
                                        volume = multiplicador*volume + ((int)tecla-48);//((int)tecla-48) é o valor real da tecla pressionada em inteiro    
                                        lcd.printf("%c", tecla);
                                    }
                                    else{
                                    volume = 0;
                                    lcd.locate(17,2);}
                                    }
                                else if(tecla == 'A'){
                                    continuar = 0;
                                    volume_solta_9[programa]=volume;
                                }
                            }
                        }
                        else if(tecla == 'B' && status_tela == "solta_vol_dif"){
                            funcao_solta_vol();
                            status_tela = "solta_vol";
                            cleber = 0;
                        }
                    }//fim do if (tecla !=A)
                
                    else if(tecla == 'A'){
                        printf("\nfalou clebao");
                        cleber = 0;
                    }
                }//fim do while(cleber)
                confirmacao_vol_solta[programa]=1;
            }//fim do else if(tecla =='B' && status_tela =="salvo_conf_vol_solta")
            
            if(tecla=='A' && status_tela=="solta_pos_y"){
                status_tela="solta"; 
                continuar = 1;
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
            }
            else if(tecla=='B' && status_tela=="solta_pos_y"){
                status_tela="solta";
                continuar = 1;
                troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
            }
            
            //Ações para a tela acompanhamento (execução do programa)
            //Matriz 3x3 (6x6cm)
            int nome;
            if(pos_x_solta[programa]!=0 && pos_y_solta[programa]!=0 && volume_solta_9[programa]!=0 && dimensao_solta[programa]!=0 && status_tela == "solta"){
                printf("rotina exec");
                funcao_nome_prog();
                wait(1);
                status_tela="nome_programa";}
                if(tecla=='B' && status_tela=="nome_programa"){                
                    status_tela="solta";
                    continuar = 1;
                    troca_tela(continuar, funcao_solta1, funcao_solta2, dimensao_solta[programa],volume_solta_9[programa], pos_y_solta[programa],0,3);
                } 
                else if(tecla=='A' && status_tela=="nome_programa"){
                     //!!!!!!!!!!!!!! colocar o códgio de pegar o valor do usuário
                    nome = 0;
                    continuar=1;
                    while(continuar){
                        tecla = pega_tecla();
                        wait(t_teclado);
                        if(tecla!= 'A' && tecla!='B' && tecla!= 'k'){
                            nome = multiplicador*nome + ((int)tecla - 48);
                            lcd.cls();
                            lcd.printf("%d",nome);
                            lcd.locate(0,3);
                            lcd.printf("A-Confirmar B-Volta");
                        }
                        else if(tecla == 'A'){
                            printf("nome inserido");
                            printf("nome: %d", nome);
                            funcao_acomp();
                            est_ihm = "exec";
                            status_tela="acompanhamento";
                            continuar = 0;
                            nome_programa[programa]=nome;
                            confirmacao_pos_pega[programa]=0;
                            confirmacao_pos_solta[programa]=0;
                            confirmacao_vol_pega[programa]=0;
                            confirmacao_pos_solta[programa]=0;
                        }
                    }   
                }
        }//fim if(est_ihm == "solta")
            
        //ここまで来たよな！頑張りましたね！あと少しだよ！
        if(est_ihm == "exec"){         
            if(confirmacao_pos_pega[programa]==0 && confirmacao_pos_solta[programa]==0 && confirmacao_vol_pega[programa]==0 && confirmacao_pos_solta[programa]==0 && status_tela == "acompanhamento"){           
                cont_pipeta = 0;
               
               //Aqui definimos a posição de cada solta a partir de um pinos. 
                float pos1[2] = {pos_x_solta[programa], pos_y_solta[programa]} ; //Pino referência
                float pos2[2] = {pos_x_solta[programa]+2*dimensao_solta[programa], pos_y_solta[programa]} ;
                float pos3[2] = {pos_x_solta[programa]+4*dimensao_solta[programa], pos_y_solta[programa]} ;
                float pos4[2] = {pos_x_solta[programa], pos_y_solta[programa]+2*dimensao_solta[programa]} ;
                float pos5[2] = {pos_x_solta[programa]+2*dimensao_solta[programa], pos_y_solta[programa]+2*dimensao_solta[programa]} ;
                float pos6[2] = {pos_x_solta[programa]+4*dimensao_solta[programa], pos_y_solta[programa]+2*dimensao_solta[programa]} ;
                float pos7[2] = {pos_x_solta[programa], pos_y_solta[programa]+4*dimensao_solta[programa]} ;
                float pos8[2] = {pos_x_solta[programa]+2*dimensao_solta[programa], pos_y_solta[programa]+4*dimensao_solta[programa]} ;
                float pos9[2] = {pos_x_solta[programa]+4*dimensao_solta[programa], pos_y_solta[programa]+4*dimensao_solta[programa]};
                go_to_z(normal_z);
                //Execução da rotina em cada pino
                rotina_pino(volume_solta_1[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos1[0],pos1[1], pos_x_pega[programa],pos_y_solta[programa]);
                rotina_pino(volume_solta_2[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos2[0],pos2[1], pos_x_pega[programa],pos_y_solta[programa]);
                rotina_pino(volume_solta_3[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos3[0],pos3[1], pos_x_pega[programa],pos_y_solta[programa]);
                rotina_pino(volume_solta_4[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos4[0],pos4[1], pos_x_pega[programa],pos_y_solta[programa]);
                rotina_pino(volume_solta_5[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos5[0],pos5[1], pos_x_pega[programa],pos_y_solta[programa]);
                rotina_pino(volume_solta_6[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos6[0],pos6[1], pos_x_pega[programa],pos_y_solta[programa]);
                rotina_pino(volume_solta_7[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos7[0],pos7[1], pos_x_pega[programa],pos_y_solta[programa]);
                rotina_pino(volume_solta_8[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos8[0],pos8[1], pos_x_pega[programa],pos_y_solta[programa]);
                rotina_pino(volume_solta_9[programa], tipo_pega[programa], medida_lado_pega[programa], volume_pega[programa], pos9[0],pos9[1], pos_x_pega[programa],pos_y_solta[programa]);
                programa+=1;
                printf("CABÔ HEIN");
                lcd.cls();
                lcd.printf("Operacao finalizada!");
                lcd.locate(1,0);
                wait(0.5);
                lcd.printf("Redirecionando para");
                lcd.locate(2,0);
                lcd.printf("    a tela inicial...");
                wait(3);
                status_tela = "inicio";
                funcao_inicio();
                if (programa==5){
                    lcd.cls();
                    lcd.printf("Limite de programas");
                    lcd.locate(1,0);
                    lcd.printf("      atingido!");
                    lcd.locate(2,0);
                    lcd.printf("Proximo programa");
                    lcd.locate(3,0);
                    lcd.printf("substitui o primeiro");
                    programa = 0;   
                }
            }

        }//fim do if(est_ihm == "exec")
    }//fim do while(1)
}//fim do int main