#include "mbed.h"
#include "usbhid.h"

DigitalOut led(LED1);

BusIn buttons(
    p5, p6, p7, p8,      // PS3: Square, x, o, Triangle
    p9, p10, p11, p12,   // PS3: L1, R1, L2, R2 
    p13, p14, p15, p16   // PS3: SELECT, START, L3, R3
);

AnalogIn analog_x(p17);  // PS3: Left Analog Stick X-axis
AnalogIn analog_y(p18);  // PS3: Left Analog Stick Y-axis
AnalogIn analog_z(p19);  // PS3: Right Analog Stick X-axis
AnalogIn analog_rz(p20); // PS3: Right Analog Stick Y-axis

BusIn stick(
    p15, p12, p13, p16   // PS3: Up, Down, Left, Right
);

USBJoystick joystick;

int main() {
    while(1) {
        signed char x = (analog_x.read_u16() >> 8) - 0x80;
        signed char y = (analog_y.read_u16() >> 8) - 0x80;
        signed char z = (analog_z.read_u16() >> 8) - 0x80;
        signed char rz = (analog_rz.read_u16() >> 8) - 0x80;
        
        joystick.joystick(0,stick.read() , x, y, z, rz);
        
        led = (buttons > 0 || stick > 0) ? 1 : 0;
        
        wait(0.01);
    }
}
