#pragma once

typedef char GantsID;
typedef char GameID;
typedef char PlayerID;
typedef char SongID;
typedef char GameMode;

enum GameMode_e { GUNNER, RPS, AirGuitar, WAITING, TEST};
enum AirGuitar_opMode_e {PICK, FRET};
enum AirGuitar_note_e {DO, RE, MI, FA, SOL, LA, SI};

typedef struct {
    GameID  game;
    PlayerID     players[2];
    PlayerID    winner;
    int     score_winner;
    int         score_looser;
} Game_Stats;

typedef struct {
    uint16_t     x;
    uint16_t     y;
    uint16_t     z;
} Accel_t;

typedef struct {
    GameID  game;
    PlayerID    players;
    SongID     track_played;
} Game_Stats_AirGuitar;

struct flex_t{
    bool index;
    bool majeur;
    bool annulaire;
    
    bool operator !=(const flex_t& a)  
    {
        return( index != a.index && 
                majeur != a.majeur &&
                annulaire != a.annulaire
        );
    }
};


typedef struct {
    GameMode_e game;
} Fixe_Vers_Mobile;

typedef struct {
    GantsID     gants;
    flex_t      flexSensor;
} Mobile_Vers_Fixe;

//data structure
typedef struct
{
    char array[50];
    int size;
} data;