#include "FlexSensor.h"

Serial f_pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

FlexSensor::FlexSensor() //default constructor
{
    FlexSensor(p18, p19, p20, p17);
}

FlexSensor::FlexSensor(PinName pinIndex, PinName pinMajeur, PinName pinAnnulaire, PinName pinReference)
{
    this->AinIndex = new AnalogIn(pinIndex);
    this->AinMajeur = new AnalogIn(pinMajeur);
    this->AinAnnulaire = new AnalogIn(pinAnnulaire);
    this->AinRef = new AnalogIn(pinReference);

    flex_data.index = 0x01;
    flex_data.majeur = 0x01;
    flex_data.annulaire = 0x01;

}

FlexSensor::~FlexSensor()
{
    delete this->AinIndex;
    delete this->AinMajeur;
    delete this->AinAnnulaire;
    delete this->AinRef;
}

void FlexSensor::Run()
{
    while(true) {
        mutex.lock();
        unsigned short Vref = AinRef->read_u16();
        AinIndex->read_u16() > Vref ? flex_data.index = 1 : flex_data.index = 0;
        AinMajeur->read_u16() > Vref ? flex_data.majeur = 1 : flex_data.majeur = 0;
        AinAnnulaire->read_u16() > Vref ? flex_data.annulaire = 1 : flex_data.annulaire = 0;

        led1 = flex_data.index;
        led2 = flex_data.majeur;
        led3 = flex_data.annulaire;
        mutex.unlock();
    }
}

flex_t FlexSensor::get_flex_values()
{
    mutex.lock();
    flex_t result = flex_data;
    mutex.unlock();

    return result;
}
