#include "CountDown.h"
CountDown::CountDown(int time)
    // initialisation list
    : t(time>>2) /// division par 4 pour temps entre ch. LED. 
{
    //pc.printf("constructor time %i \r\n", t);
    led[0] = new DigitalOut(LED1);
    led[1] = new DigitalOut(LED2);
    led[2] = new DigitalOut(LED3);
    led[3] = new DigitalOut(LED4);
    
}

CountDown::~CountDown()
{
    for(int i(0); i<NBRE_LED; i++){
        delete led[i];
    }
}

bool CountDown::run()
{
    int j(NBRE_LED);
    
    for(int i(0); i<j ; i++){ // ALL ON. 
        led[i]->write(1);
    }
    
    while(j) // Actual CountDown. 
    {
        j--;
        Thread::wait(t);
        led[j]->write(0);
    }
    
    for(int u(0); u < NBRE_LED; u++) // Flashing State
    {
        Thread::wait(100);
        for(int i(0); i<NBRE_LED ; i++){
            led[i]->write(u%2);
        }
    }
        
    return true;
}