#include "mbed.h"
#include "rtos.h"
#include "Structure.h"

class Xbee
{
    public :
        Xbee();
        Xbee(short panId, PinName pinTx, PinName pinRx);
        ~Xbee();
        
        void GetData(); //remplace recevoir();
        void OutputData();
        void ReceivePacket(data* trame);
        void EnvoyerStructure(Mobile_Vers_Fixe mvf);
        Mail<Fixe_Vers_Mobile,100> fvm_mailbox;
       
    private:

        short PanId;
        char HexToAscii[16];
        Mail<data,100> mailbox;
        
        void SendData(char data[], int messageSize);
        void SendXBee(char array[], int size);
        void SetPanId(short panId);
        void BuildHexToAsciiTable();
};