/* S5 Projet - Conception d'un systeme embarque reseaute
 * main.cpp
 *
 * @author Equipe de projet 2
 *
 */

// System libraries
#include "mbed.h"
#include "rtos.h"

// Proprietary libraries
#include "Cible.h"
#include "CountDown.h"
#include "FlexSensor.h"
#include "MMA8452Q.h"
#include "Structure.h"
#include "Xbee.h"

#define GO 0x01
#define ACTIVATE_FLEX 1
#define ACTIVATE_ACCEL 1
#define XBEE_TRANSMIT 3

Serial m_pc(USBTX, USBRX);
LocalFileSystem local("local"); // file system for config.txt

//PROTOTYPES DE FONCTION
void gunner(void const* args);
void rps(void const* args);
void airGuitar(void const* args);
void flex(void const* args);
void transmit_xbee_data(void const* args);
void analyze_sensor_data(void const* args);
void configure_GUNNER();
void configure_RPS();
void configure_GUITAR();
void ReadConfig();
void timer2_init(void);
void GetGameMode(void const* args);

uint8_t play = 0;
uint8_t windup = 0;

FlexSensor flexSensors(p18, p19, p20, p17);       // flex sensor 1.
Accel accel;
flex_t flex_data;
Mobile_Vers_Fixe mail_mvf;
//RtosTimer *sync;
GameMode_e mode = RPS;
AirGuitar_opMode_e opMode;
short PanId;
char GantID;
Xbee xbee;

Thread *threads[4];
Thread* gunner_thread_ptr = NULL;       // Possiblement mettre dans un tableau
Thread* rps_thread_ptr = NULL;          // avec des position codees
Thread* airguitar_thread_ptr = NULL;    // dans des define. guillaume
Thread* flex_thread_ptr = NULL;         // Lecture des entrées analogiques
Thread* Thread_Send_Data_To_Fixe = NULL;// Thread pour envoyer les données des sensors au fixe
Thread* transmit_xbee_data_thread_ptr = NULL;

Thread* xbeeAnalyzer = NULL;
Thread* xbeeReceive = NULL;
Thread* threadGetGameMode = NULL;


extern "C" void TIMER2_IRQHandler(void)
{
    /*Flag du decodage - s'execute a chaque fronts, descendants et montants*/
    if ((LPC_TIM2->IR & 0x20) == 0x20) {
        LPC_TIM2->IR |= 0x20;     // clear Timer2 interrupt register
        threads[mode]->signal_set(0x02);
    }
}

//Fonction qui part le thread
void startXbeeReceive(void const* args)
{
    xbee.GetData();
}

void startXbeeAnalyzer(void const* args)
{
    xbee.OutputData();
}


int main(void const* args)
{
    m_pc.printf("\r\n==== PROGRAM START MOBILE ====\r\n");
    // Initializing the accelerometer

    ReadConfig(); //read config file
    opMode = PICK; // temporaire
    m_pc.printf("PANID %x\r\n", PanId);
    m_pc.printf("opMode %u\r\n", opMode);
    xbee = Xbee(PanId, p13, p14); //set PAN ID
    xbeeAnalyzer = new Thread(startXbeeAnalyzer);
    xbeeReceive = new Thread(startXbeeReceive);
    threadGetGameMode = new Thread(GetGameMode);

#if ACTIVATE_ACCEL
    accel = Accel();
    accel.init_MMA8452();
    timer2_init();
#endif
    transmit_xbee_data_thread_ptr =  new Thread(transmit_xbee_data);
    gunner_thread_ptr =  new Thread(gunner);
    flex_thread_ptr = new Thread(flex);
    rps_thread_ptr =  new Thread(rps);

    airguitar_thread_ptr = new Thread(airGuitar);

    threads[GUNNER] = gunner_thread_ptr;
    threads[RPS] = rps_thread_ptr;
    threads[AirGuitar] = airguitar_thread_ptr;
    threads[XBEE_TRANSMIT] = transmit_xbee_data_thread_ptr;
    configure_RPS();
    while(true) {
    }
}

void timer2_init(void)
{
    LPC_PINCON->PINSEL0  |= 0xc00;      // set P0.5 to CAP2.1
    LPC_PINCON->PINMODE0 |= 0xc00;       // pull-down enable
    LPC_SC->PCONP    |= (1 << 22);      // Timer2 power on
    LPC_SC->PCLKSEL1 |= (1 << 12);      // Divide CCLK by 1 for Timer2
    LPC_TIM2->CCR    |= 0x30;           // set cap2.1 rising-edge/falling-edge and interrupt
    LPC_TIM2->TCR    |= (1 << 0);       // start Timer2
    LPC_TIM2->EMR     = 0x20;           //
    LPC_TIM2->IR     |= 0xFFFFFFFF;
    NVIC_EnableIRQ(TIMER2_IRQn);
}

void flex(void const* args)
{
    flexSensors.Run();
}

void GetGameMode(void const* args)
{
    while (true) {
        // attente et lecture d'un événement digital
        osEvent evtD = xbee.fvm_mailbox.get();
        if (evtD.status == osEventMail) {
            Fixe_Vers_Mobile *mail = (Fixe_Vers_Mobile*)evtD.value.p;
            mode = mail->game;
            // Envoyer la structure
            xbee.fvm_mailbox.free(mail);
            switch(mode) {
                case 0:
                    m_pc.printf("Led Gunner Start! FVM \n\r");
                    configure_GUNNER();
                    break;
                case 1:
                    m_pc.printf("RPS Start! FVM\n\r");
                    configure_RPS();
                    break;
                case 2:
                    m_pc.printf("Air Guitar Start! FVM\n\r");
                    configure_GUITAR();
                    break;
                default:
                    break;
            }
            m_pc.printf("\n\r Mode recu: %x \n\r", mode);
        }
    }
}


void gunner(void const* args)
{
    // local variables
    while(true) {
        Thread::signal_wait(0x02);
        flex_data = flexSensors.get_flex_values();
        while(flex_data.index != 0) {
            wait(10);
            flex_data = flexSensors.get_flex_values();
        }
        mail_mvf.flexSensor = flex_data;
        mail_mvf.gants = 'D';
        threads[XBEE_TRANSMIT]->signal_set(0x01);
    }
}

void configure_GUNNER()
{
    accel.set_TRANSIENT_MODE(0x18, 0x05, 0x08); // z plan transient motion detection
}

void transmit_xbee_data(void const* args)
{
    while(1) {
        Thread::signal_wait(0x01);
        xbee.EnvoyerStructure(mail_mvf);
        wait(0.1);
    }
}

void rps(void const* args)
{
    Mobile_Vers_Fixe mailGauche;
    mailGauche.flexSensor.index = true;
    mailGauche.flexSensor.annulaire = true;
    mailGauche.flexSensor.majeur = true;
    mailGauche.gants = 'G'; // Gauche ou Droit

    // local variables

    while(true) {
        Thread::signal_wait(0x02);
        windup++;
        m_pc.printf("Decide in : %d \n\r", windup);
        if(windup >= 3) {
            windup = 0;
            Thread::wait(500);
            //flex_data = flexSensors.get_flex_values();
            mail_mvf.flexSensor.index = false;
            mail_mvf.flexSensor.annulaire = false;
            mail_mvf.flexSensor.majeur = false;
            mail_mvf.gants = 'D'; // Gauche ou Droit
            m_pc.printf("Envoie de mail");
            threads[XBEE_TRANSMIT]->signal_set(0x01);
            /* mail_mvf = mailGauche;
             threads[XBEE_TRANSMIT]->signal_set(0x01);
            */
            // send data frame to the fixed mbed for analyze
        }
        accel.clear_TRANSIENT_INTERRUPT();
    }
}


void configure_RPS()
{
    accel.set_TRANSIENT_MODE(0x12, 0x05, 0x08);
}

void airGuitar(void const* args)
{
    mail_mvf.flexSensor.index = true;
    mail_mvf.flexSensor.annulaire = true;
    mail_mvf.flexSensor.majeur = true;
    if(opMode == PICK) {
        mail_mvf.gants = 'P'; // Droit
    } else if(opMode == FRET) {
        mail_mvf.gants = 'F'; // Gauche
    }

    flex_t flex_data;
    while(true) {
        switch(opMode) {
            case PICK:
                Thread::signal_wait(0x02);
                threads[XBEE_TRANSMIT]->signal_set(0x01);
                accel.clear_TRANSIENT_INTERRUPT();
                break;
            case FRET:

                flex_data = flexSensors.get_flex_values();
                if(flex_data != mail_mvf.flexSensor) {
                    mail_mvf.flexSensor = flex_data;
                    threads[XBEE_TRANSMIT]->signal_set(0x01);
                }
                Thread::wait(50);

                break;
            default:
                break;
        }

    }
}

void configure_GUITAR()
{
    accel.set_TRANSIENT_MODE(0x12, 0x05, 0x08); // z plan transient motion detection
}

//read config file
void ReadConfig()
{
    FILE* file = fopen("/local/config.txt","r");
    if (file != NULL) {
        char buffer[2];

        fscanf(file, "%x", &buffer); //panID = 2 char
        PanId = buffer[1] << 8 | buffer[0]; //set PAN ID global variable

        fscanf(file, "%x", &buffer);
        GantID = buffer[0];

        char mode[4];
        fscanf(file, "%x", mode);
        if(mode == "FRET")
            opMode = FRET;
        if(mode == "PICK")
            opMode = PICK;

        fclose(file); //close file
    } else { //if file is not found
        m_pc.printf("ERROR AT CONFIG FILE \r\n");
    }
}