#include "mbed.h"

#ifndef _TIMER2_H_
#define _TIMER2_H_
 
#define MR0_INTERRUPT_ID 0x01
#define MR1_INTERRUPT_ID 0x02
#define MR2_INTERRUPT_ID 0x04
#define MR3_INTERRUPT_ID 0x08
#define CR0_INTERRUPT_ID 0x10
#define CR1_INTERRUPT_ID 0x20

#define TIMER2_EMC_NOT 0
#define TIMER2_EMC_LOW 1
#define TIMER2_EMC_HIGH 2
#define TIMER2_EMC_TOGGLE 3

typedef void (*timerCb_t)();

class Timer2 {
    
    public:
        Timer2(int period, void (*timerCb)(void));
        ~Timer2();
        void start(void);
        
        void setMatchRegister(unsigned int value);
        void incrementMatchRegister(int value);
        
        bool getIntAtPos(int pos);
        void clearIntAtPos(int pos);
        
        void setEMC(int value);
        
        void Set_RE(bool b);
        void Set_FE(bool b);
        
    private:
        timerCb_t callback;
};


#endif