#include "mbed.h"
#define SPEED 0.05
#define W_ADDR 0x3A
#define R_ADDR 0x3B
#define WHO_AM_I 0x0D
#define CTRL_REG1 0x2A
#define X_OUT_MSB 0x01
#define TRANSIENT_CFG 0x1D
#define THRESHOLD_REG 0x1F
#define DEBOUNCE_CFG 0x20
#define CTRL_REG4 0x2D
#define CTRL_REG5 0x2E
#define TRANSIENT_VALUE 0x1E
 
typedef struct {
    uint16_t x;
    uint16_t y;
    uint16_t z;
} accel_t;
 
class Accel
{
public:
    // Public member attrbutes
    int nack;
    accel_t accel_data;
    
 
    //public member functions
    Accel();
    uint8_t init_MMA8452();
    uint8_t get_WHO_AM_I();
    uint8_t set_CTRL_REG1();
    accel_t get_axis_values();
    uint8_t set_STANDBY_MODE();
    uint8_t set_TRANSIENT_MODE(char axis, char count, char debounce);
    uint8_t clear_TRANSIENT_INTERRUPT();
};
 