#include "MMA8452Q.h"
Serial a_pc(USBTX, USBRX);
I2C i2c(p28, p27);
 
Accel::Accel()
{
}
 
uint8_t Accel::get_WHO_AM_I()
{
    char cmd = WHO_AM_I;
    char data[2] = {0x00, 0x00};
    nack = i2c.write(W_ADDR, &cmd, 1, true); //send a request to WHO_AM_I register, we expect 0x2a, or 42, the answer to the universe.
    wait(SPEED);
    if (!nack) {
        nack = i2c.read(R_ADDR, data, 1);
        wait(SPEED);
        if (!nack) {
            if(data[0] == CTRL_REG1) {
                a_pc.printf("I2C communication succes: Module MMA8452 online\r\n");
            }
        } else {
            a_pc.printf("I2C communication fail: Module MMA8452 offline\r\n");
            a_pc.getc();
            return 1;
        }
    }
    return 0;
}
 
uint8_t Accel::set_CTRL_REG1()
{
    char cmd[2];
    cmd[0] = CTRL_REG1;
    cmd[1] = 0x01; //byte to enable the device
 
    nack = i2c.write(W_ADDR, cmd, 2, true); //comand to enable the device
    wait(SPEED);
    if (!nack) {
        a_pc.printf("I2C communication success: CTRL_REG1 configured\r\n");
    } else {
        a_pc.printf("I2C communication fail: Could not configure CTRL_REG1\r\n");
        a_pc.getc();
        return 1;
    }
    return 0;
}
 

uint8_t Accel::init_MMA8452()
{
    Serial a_pc(USBTX, USBRX);
    a_pc.printf("\r\n\r\n================================================\r\n\r\n");
    a_pc.printf("Accelerometer I2C interface: Initialization sequence starting...\r\n");
 

    get_WHO_AM_I();
    wait_ms(50);
    set_CTRL_REG1();
 

    return 0;
}
 

accel_t Accel::get_axis_values()
{
    char cmd = X_OUT_MSB;
    char data[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    accel_t a_data;
 

    nack = i2c.write(W_ADDR, &cmd, 1, true); //request the data in the 6 out registers
    wait(SPEED);
    if (!nack) {
        nack = i2c.read(R_ADDR, data, 6); //receive the data from the 6 out registers
        wait(SPEED);
        a_data.x = (data[0] << 4) + (data[1] >> 4);
        a_data.y = (data[2] << 4) + (data[3] >> 4);
        a_data.z = (data[4] << 4) + (data[5] >> 4);
 

        if (!nack) {
        }
    } else {
        a_pc.printf("I2C communcation fail: Command %#X at address %#X\n", cmd, W_ADDR);
        a_pc.getc();
    }
    return a_data;
}
 

uint8_t Accel::set_STANDBY_MODE()
{
    char cmd[2];
    cmd[0] = CTRL_REG1;
    cmd[1] = 0x18; //byte to put the device in standby mode

    nack = i2c.write(W_ADDR, cmd, 2, true); //command to put the device in standby mode
    wait(SPEED);
    if (!nack) {
        a_pc.printf("I2C communication success: Device now in STANDBY mode\r\n");
    } else {
        a_pc.printf("I2C communication fail: Could not put device in STANDBY mode\r\n");
        a_pc.getc();
        return 1;
    }
    return 0;
}

uint8_t Accel::set_TRANSIENT_MODE(char axis, char count, char debounce)
{
    set_STANDBY_MODE();
    char cmd[2];
    cmd[0] = TRANSIENT_CFG;
    cmd[1] = axis;
    nack = i2c.write(W_ADDR, cmd, 2, true); //command to configure the TRANSIENT_CFG Register
    wait(SPEED);
    if (!nack) {
        a_pc.printf("I2C communication success: Device configured for TRANSIENT_DETECTION mode on selected axis\r\n");
    } else {
        a_pc.printf("I2C communication fail: Could not put device in TRANSIENT_DETECTION mode on selected axis\r\n");
        a_pc.getc();
        return 1;
    }

    cmd[0] = THRESHOLD_REG;
    cmd[1] = count;
    nack = i2c.write(W_ADDR, cmd, 2, true); //command to configure the TRANSIENT_CFG Register
    wait(SPEED);
    if (!nack) {
        a_pc.printf("I2C communication success: Device configured for THRESHOLD_REG mode on threshold count\r\n");
    } else {
        a_pc.printf("I2C communication fail: Could not put device in THRESHOLD_REG mode on threshold count \r\n");
        a_pc.getc();
        return 1;
    }

    cmd[0] = DEBOUNCE_CFG;
    cmd[1] = debounce;
    nack = i2c.write(W_ADDR, cmd, 2, true); //command to configure the TRANSIENT_CFG Register
    wait(SPEED);
    if (!nack) {
        a_pc.printf("I2C communication success: Device configured for DEBOUNCE_CFG mode on debounce count\r\n");
    } else {
        a_pc.printf("I2C communication fail: Could not put device in DEBOUNCE_CFG mode on debounce count \r\n");
        a_pc.getc();
        return 1;
    }
    cmd[0] = CTRL_REG4;
    cmd[1] = 0x20;
    nack = i2c.write(W_ADDR, cmd, 2, true); //command to configure the TRANSIENT_CFG Register
    wait(SPEED);
    if (!nack) {
        a_pc.printf("I2C communication success: Device configured for CTRL_REG4 \r\n");
    } else {
        a_pc.printf("I2C communication fail: Could not put device in CTRL_REG4\r\n");
        a_pc.getc();
        return 1;
    }

    cmd[0] = CTRL_REG5;
    cmd[1] = 0x20;
    nack = i2c.write(W_ADDR, cmd, 2, true); //command to configure the TRANSIENT_CFG Register
    wait(SPEED);
    if (!nack) {
        a_pc.printf("I2C communication success: Device configured for CTRL_REG5\r\n");
    } else {
        a_pc.printf("I2C communication fail: Could not put device in CTRL_REG5 \r\n");
        a_pc.getc();
        return 1;
    }

    set_CTRL_REG1();
    return 0;
}

uint8_t Accel::clear_TRANSIENT_INTERRUPT()
{
    char cmd = TRANSIENT_VALUE;
    char data[2] = {0x00, 0x00};
    nack = i2c.write(W_ADDR, &cmd, 1, true); //command to put the device in standby mode
    wait(SPEED);
    if (!nack) {
        nack = i2c.read(R_ADDR, data, 1);
        if(!nack) {
            a_pc.printf("I2C communication success: Cleared TRANSIENT_REG\r\n");
        } else {
            a_pc.printf("I2C communication fail: Could not clear TRANSIENT_REG\r\n");
            a_pc.getc();
            return 1;

        }
    }
    return 0;
}
