/*-- BIBLIOTHEQUES --*/
#include "mbed.h"
#include "ssd1306.h"
#include "standard_font.h"
#include "bold_font.h"
#include "DHT22.h"
#include "Adafruit_TCS34725.h"
/*-------------------*/

/*--     DEFINES      --*/
#define commonAnode true

#define ERR_RGB 0
/*----------------------*/


/*--    PROTOTYPES     --*/
void GetDataAir(void);
void InitEcran(void);
void GestionEcran(void);
void ErrorDisplay(int ErrorNumber);
void initRGB();
void GestionRGB();
/*-----------------------*/


/*-- PERIPHERIQUES --*/
SSD1306 oled(D9,D6,D10,A4,A6); // OLED : CS,Reset,DC,Clock,Data (SPI1)
I2C i2c(D4,D5);//SDA SCL
//DigitalOut myled(LED1);//ATTENTION LED1 = D13
DHT22 dht22(D3);    //Capteur Temperature AIR
Serial pc(USBTX, USBRX);
Adafruit_TCS34725 tcs = Adafruit_TCS34725(&i2c, TCS34725_INTEGRATIONTIME_50MS, TCS34725_GAIN_4X); //RGB Sensor
DigitalOut LedTCS(D11);

AnalogIn sondeHum(A0);  //Capteur Humidite SOL
AnalogIn sondeTemp(A1); //Capteur Temperature SOL
/*--------------------*/


/*-- VARIABLES GLOBALES --*/
float humAir=12.12;//Valeur d'init pour verifier pannes
float tempAir=13.13;
    
float humSol=14.14;//Valeur d'init pour verifier pannes
float tempSol=15.15;

int r,g,b;
/*-----------------------*/

int main() {
    
    pc.printf("\n\r\tProjet SERRE : \n\r");  
    pc.printf("\n\r\tCURIEL DKHEILA FURA\n\r\n\r");  
    
    initRGB();   
    
    InitEcran();
    
    while(1) {
        
        wait(1.0); // 1 sec
        
    /*-- Humidite & Temperature AIR --*/
        GetDataAir();

    /*-- Humidite & Temperature SOL --*/       
        humSol=sondeHum;//A MODIFIER !!!!!
        //tempSol=sondeTemp; //A MODIFIER!!!!!
        pc.printf("SOL\n\f");
        pc.printf("Humidite: %.2f %%\r\n", humSol);    
        //pc.printf("Temperature: %.2f C\r\n\r\n", tempSol); */
        
    /*-- LUMIERE --*/
        
        /*__ RGB __*/
        //GestionRGB();
        
        /*__ Spectre visible et infrarouge __*/ 
        
    /*-- AFFICHAGE --*/    
        GestionEcran();
    }
}

//Lecture de l'humidite et de la temperature de l'air
void GetDataAir(void)
{
    dht22.sample() ;
    humAir=dht22.getHumidity()/10.0;
    tempAir=dht22.getTemperature()/10.0;
    
    pc.printf("AIR\r\n");
    pc.printf("Humidite: %.2f %%\r\n", humAir);    
    pc.printf("Temperature: %.2f C\r\n\r\n", tempAir); 
}

//Initialisation de l'ecran
void InitEcran(void)
{
    oled.initialise();
    oled.clear();
    oled.set_contrast(255); // max contrast
    oled.update();
    
    oled.clear();
    oled.set_font(bold_font, 8);
    oled.printf("Bienvenue\n\ra Jurassic Park\r\n");
    oled.update();
    
    wait(1);
}

//Affichage des donnees utiles sur l'ecran
void GestionEcran(void)
{
    oled.clear();
        
    //AIR
    oled.set_font(bold_font, 8);
    oled.printf("AIR\r\n");
    oled.set_font(standard_font, 6);
    oled.printf("Humidite: %.2f %%\r\n", humAir);    
    oled.printf("Temperature: %.2f C\r\n", tempAir); 
    
    //SOL 
    oled.set_font(bold_font, 8);
    oled.printf("SOL\r\n");
    oled.set_font(standard_font, 6);
    oled.printf("Humidite %.2f %\r\n", humSol); 
    //oled.printf("Temperature %.2f C\r\n", tempSol);  
    
    //RGB
    oled.set_font(bold_font, 8);
    oled.printf("Couleurs\r\n");
    oled.set_font(standard_font, 6);
    oled.printf("R: %d, G: %d, B: %d\r\n",r, g, b); 
    
    oled.update();
}

//Affichage de code erreur sur l'ecran
void ErrorDisplay(int ErrorNumber)
{
    oled.clear();
    oled.set_font(bold_font, 8);
    oled.printf("ERREUR : %d\r\n",ErrorNumber);
    oled.update();
    pc.printf("ERREUR : %d\r\n",ErrorNumber); 
    wait(2);
}

//Initialisation du capteur de couleurs RGB
void initRGB(void)
{
    if (tcs.begin())
    {
        pc.printf("Found sensor");
        LedTCS=1;
    }
    else
    {
        pc.printf("No TCS34725 found ... check your connections");
        ErrorDisplay(ERR_RGB);
        while (1); // halt!
    }
}

//Acquisition des couleurs avec le capteur RGB
void GestionRGB(void)
{
        uint16_t clear, red, green, blue;
        
        LedTCS=0;
        wait(0.1);
        
        tcs.setInterrupt(false);      // turn on LED
        tcs.getRawData(&red, &green, &blue, &clear);
        tcs.setInterrupt(true);  // turn off LED
        //printf("%d, %d, %d, %d\r\n", clear, red, green, blue);
        
        // Conversion Hexa
        uint32_t sum = clear;
        r = red; r /= sum;
        g = green; g /= sum;
        b = blue; b /= sum;
        r *= 256; g *= 256; b *= 256;
        pc.printf("R : %d, G : %d, B : %d\r\n",  r, g, b); 
        
        LedTCS=1;
}