#include "mbed.h"
#include "GroveColourSensor.hpp"

//I2C i2c(p9, p10);

int main() {
    
    BusOut myleds(LED1, LED2, LED3, LED4);
    GroveColourSensor colorSensor(p9, p10);
    
    
    int i=0;
    uint16_t colourValue;
    unsigned colour; 
    char col[6]; 
            
    int green, red, blue;
    
    colorSensor.powerUp(); 
    
    while(1) {
        for (colour = GroveColourSensor::GREEN; colour < GroveColourSensor::NUM_COLORS; colour++) { 
            colourValue = colorSensor.readColour(colour);
            
            }
           
        while(colourValue>0)
        { 
            col[i]=colourValue%2; 
            colourValue=colourValue/2; 
            i++;
        }
                     
        green  = col[1] * 256 + col[0];
        red    = col[3] * 256 + col[2];
        blue   = col[5] * 256 + col[4];
        
        if (red>=green && red>=blue) {
            myleds = 2;
            wait(0.5); 
            }
            
        else if (green>=red && green>=blue) {
            myleds = 4;
            wait(0.5); 
            }
        else if(blue>=red && blue>=green) {
            myleds = 8;
            wait(0.5); 
            }
           // else myleds = i;
        else {     
            myleds = 15;
            wait(0.5); 
            }
        }
        //colorSensor.powerDown();
                        
    }
     
