#include <mbed.h>
#include <AX12.h>
#include <iostream>
#include <iomanip>
#include <sstream>


using namespace std;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

/* ************************************************************ */
/* Déclarations variables globales et fonctions pour HMC5883L   */
/* ************************************************************ */
short Bx, By, Bz;
I2C hmc(p9, p10); 
const int addr = 0x1E; // adresse d'écriture de du capteur
//int frequency(100000);
void hmc_config(void);
void hmc_lecture(void);

/* ************************************************** */
/*  Déclarations des var globales de communication    */
/* ************************************************** */
Serial conf(p9, p10);
Serial pc(USBTX, USBRX);

/* ********************************************* */
/*  Déclarations des var globales de position    */
/* ********************************************* */
int moteur1i;
int moteur2i;
int moteur3i;

/* ********************************************* */
/*  Déclarations des var globales de position    */
/* ********************************************* */
bool flag;

/* ********************************************* */
/*  Déclarations des var globales moteur         */
/* ********************************************* */
AX12 myax01 (p28, p27, 1);
AX12 myax02 (p28, p27, 2);
AX12 myax03 (p28, p27, 3);
AX12 myax04 (p28, p27, 6);

/* ********************************************* */
/*  Déclarations des var globales des relever de position         */
/* ********************************************* */
float checkmot1;
float checkmot2;
float checkmot3;
float checkmot4;

void Lecture(void);
void envoi_position(void);
void lecture_position(void);
void envoi_12octets(void);


int main() 
{ 
       led1 = 1;
       Lecture();
       led1 = 0;
       led2 = 1;
       envoi_position();
       led2 = 0;
       led3 = 1;
       hmc_config();
       led3 = 0;
       led4 = 1;
       hmc_lecture();
       led4 = 1;
       led1 = 1;
       lecture_position();
       led1 = 0;
       led2 = 1;
       envoi_12octets();
       led1 = 1;
       led2 = 1;
       led3 = 1;
       led4 = 1;
               
    
           // pc.printf("\nBx=%d, By=%d, Bz=%d\n\r",Bx*4.35,By*4.35,Bz*4.35);
           
           
         

}

/* ************************************** */
/* Fonction de confihuration de HMC5883l  */
/* Mode:single, sensibilité +/- 8Guauss   */
/*                                        */
/* ************************************** */
void hmc_config(void)
     {
         conf.baud(9600);
         //Variable interne à la fonction.
         char config_hmc[2];
         config_hmc[0]=0x00;  // adresse registre A
         config_hmc[1]=0x70;// registre A configuré en mesure normal sur 16 bits
         hmc.write(addr, config_hmc,2);
    
         config_hmc[0]=0x01;  // à commenter
         config_hmc[1]=0xE0;
         hmc.write(addr, config_hmc,2);
    
         config_hmc[0]=0x02; // à commenter
         config_hmc[1]=0x01;
         hmc.write(addr, config_hmc,2);
        
         wait(0.006); // attente imposée constructeur
         
     }    
     
  /* ************************************** */
  /* Fonction de lecture champ magnétique   */
  /* sur 3 axes, chaque lecture sur 16 bits */
  /* ************************************** */   
  
  void hmc_lecture()
      {
        //Variable interne a la fonction.
        char readhmc[6];
        
        hmc.read(addr, readhmc, 6);     // commenter
        
        Bx=((readhmc[0] << 8)|readhmc[1]); // commenter le décalage
        By=((readhmc[2] << 8)|readhmc[3]);
        Bz=((readhmc[4] << 8)|readhmc[5]);
        
        wait(0.07);    
          
      }    
   /* *********************************************  */
  /*        Fonction de lecture de la trame         */
  /* *********************************************  */

void Lecture(void) {
    
    string trame;        //Trame complète.
    stringstream sstr;   //stringstream permet de faire la liaison entre le string de départ et le int sortant.
    int cchecksum = 0;       //Octet permetant le controle de 'checksumi'.
    string moteur1;      //Octet de position moteur1.
    string moteur2;      //Octet de position moteur2.
    string moteur3;      //Octet de position moteur3.
    string checksum;     //Octet du checksum.
    int checksumi;       //'checksum' converti en int.
    char tablecture[15];  //Tableau de reception
    char reception[1];
    int tablecturei[15];  //Tableau de reception converti en int
    string tab;       //Octet de start.
    int tabi[14];         //'start1' converti en int.
    string start1;       //Octet de start.
    int start1i;         //'start1' converti en int.
    string start2;       //Octet de start.
    int start2i;         //'start2' converti en int.
    string start3;       //Octet de start.
    int start3i;         //'start1' converti en int.
    string start4;       //Octet de start.
    int start4i;         //'start2' converti en int.
    conf.baud(9600);
    
    
    //tablecture = conf.getc();
    
    for(int i = 0; i<15; i++){
       conf.gets(reception, 2);
       pc.printf("\nreception = %s \n",reception);
       trame += reception;
       //tablecture[i] = conf.getc();    //Récupère la trame complète sur 15 Octets dans un trableau de char.
       //conf.scanf("%d", &tablecture[i]);
       //pc.printf("\ntablecture[%d] = %s \n",i,tablecture[i]);
       //pc.printf("\ntablecturei[%d] = %d \n",i,tablecturei[i]);
       //trame = tablecture[i];
    }
    
    //trame = tablecture;         //Copie le contenue de 'tablecture' dans 'trame'.
    pc.printf("\ntrame = %s \n",trame);
    led1 = 1;
    
    for(int i=0; i<13; i++){
        tab = trame.substr(i,1);
        tabi[i] = tab[0];
        cchecksum += tabi[i];
        pc.printf("\ntab[%d] = %s \n", i, tab);
        pc.printf("\ntabi[%d] = %d \n", i, tabi[i]);
        pc.printf("\ncchecksum = %d \n",cchecksum);
        }
        
    pc.printf("\ncchecksum = %d \n",cchecksum);
    moteur1 = trame.substr(4,3); //Enregistrement de deux Nombres à partir de 4.
    sstr << moteur1; //Stock le contenue du string 'start2' dans le buffer 'sstr'.
    sstr >> dec >> moteur1i; //Enregistre le contenue du buffer 'sstr' en hexa dans l'int 'start2i'.
    sstr.clear();   //Vide le buffer de 'sstr'.
    pc.printf("\nmoteur1 = %s \n",moteur1);
    pc.printf("\nmoteur1i = %d \n",moteur1i);
    
    moteur2 = trame.substr(7,3); //Enregistrement de deux Nombres à partir de 6.
    sstr << moteur2;             //Stock le contenue du string 'start2' dans le buffer 'sstr'.
    sstr >> dec >> moteur2i;     //Enregistre le contenue du buffer 'sstr' en hexa dans l'int 'start2i'.
    sstr.clear();   //Vide le buffer de 'sstr'.
    pc.printf("\nmoteur2 = %s \n",moteur2);
    pc.printf("\nmoteur2i = %d \n",moteur2i);
    
    moteur3 = trame.substr(10,3); //Enregistrement de deux Nombres à partir de 8.
    sstr << moteur3;             //Stock le contenue du string 'start2' dans le buffer 'sstr'.
    sstr >> dec >> moteur3i;     //Enregistre le contenue du buffer 'sstr' en hexa dans l'int 'start2i'.
    sstr.clear();                //Vide le buffer de 'sstr'.
    led2 = 0;
    pc.printf("\nmoteur3 = %s \n",moteur3);
    pc.printf("\nmoteur3i = %d \n",moteur3i);
    
    checksum = trame.substr(13,2);   //Enregistrement de deux Nombres à partir de 10.
    sstr << checksum;                //Stock le contenue du string 'checksum' dans le buffer 'sstr'.
    sstr >> dec >> checksumi;        //Enregistre le contenue du buffer 'sstr' en hexa dans l'int 'checksumi'.
    sstr.clear();                    //Vide le buffer de 'sstr'.
    pc.printf("\nchecksum = %s \n",checksum); 
    pc.printf("\nchecksumi = %d \n",checksumi);                  
    
    cchecksum = cchecksum % 256;    //'cchecksum' % 256.
    pc.printf("\ncchecksum = %d modulo 256\n",cchecksum);
    cchecksum = cchecksum % 100;    //'cchecksum' % 100.
    pc.printf("\ncchecksum = %d modulo 100\n",cchecksum);
    
    
    if((cchecksum) == checksumi){   
        led2 = 1;
        flag = 1;
    }
    else{
        led3 = 1;
        flag = 0;
    }
}

  /* *********************************************  */
  /*       Fonction d'envoi de position moteur      */
  /* *********************************************  */
  
void envoi_position(void){
    int moteur4i;
    myax01.SetGoal(moteur1i);     //Va a la position 'moteur1i'.
    wait(0.25);                   //Attente de 0.25sec avant de commencer a placer le moteur suivant.
    myax02.SetGoal(moteur2i);     //Va a la position 'moteur2i'.
    wait(0.25);                   //Attente de 0.25sec avant de commencer a placer le moteur suivant.
    myax03.SetGoal(moteur3i);     //Va a la position 'moteur3i'.
    moteur4i = 300 - moteur3i;    //Calcul pour la position du moteur myax03.SetGoal.
    myax04.SetGoal(moteur4i);     //Va a la position 'moteur4i'.
    wait(3);
    }
      
  /* *********************************************  */
  /*      Fonction de lecture de position moteur    */
  /* *********************************************  */
  
void lecture_position(void){
    checkmot1 = myax01.GetPosition(); //Récupération de la position du moteur 'myax01'.
    checkmot2 = myax02.GetPosition(); //Récupération de la position du moteur 'myax02'.
    checkmot3 = myax03.GetPosition(); //Récupération de la position du moteur 'myax03'.
    checkmot4 = myax04.GetPosition(); //Récupération de la position du moteur 'myax04'.
    }
  /* *********************************************  */
  /*   Fonction d'envoi de la trame sur 12 Octets   */
  /* *********************************************  */
void envoi_12octets(void){
    Serial conf(p13, p14); //(tx, rx, baud)
    //Varible interne a la fonction
    int start3 = 0xFF;  //Octet de start
    int start4 = 0xFF;  //Octet de start
    int echecksum;      //Octet de Checksum
    conf.baud(9600);
    
    
    led1 = 0;
    
    conf.putc(start3);
    echecksum += start3;
    conf.putc(start4);
    echecksum += start4;
    conf.putc(checkmot1);
    echecksum += checkmot1;
    conf.putc(checkmot2);
    echecksum += checkmot2;
    conf.putc(checkmot3);
    echecksum += checkmot3;
    conf.putc(Bx);
    echecksum += Bx;
    conf.putc(By);
    echecksum += By;
    conf.putc(Bz);
    echecksum += Bz;
    conf.putc(echecksum);
        
    led3 = 1;
}