#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "card"); // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX, USBRX); // tx, rx
Serial gps(D1, D0);  // tx, rx
DigitalOut led1(LED1);
InterruptIn button(PTA4);

FILE *fp;
int run =1;

void callback() {
   char s = gps.getc();
   fprintf(fp, &s);
   //pc.printf(&s);   a enlever si on veut voir les infos du gps en continu sur le terminal
} 
void stop() {
   run =0;
}
int main() {

   pc.printf("Initialized recording\n");   
   gps.baud(9600);
   pc.baud(9600);
   mkdir("/card/gps_tracking", 0777);

   fp = fopen("/card/gps_tracking/sdfile.txt", "w");
   if(fp == NULL) {
       error("Could not open file for write\n");
   }
   gps.attach(&callback);
   pc.attach(&stop);
   button.rise(&stop);

   while(run==1) {
       led1 = !led1;
       wait(0.5);
   }
   fclose(fp); 

   pc.printf("Recording finished.\n");
}
