#include "Deplacement.h"
#include "mbed.h"
   
m3pi m3piD;

Deplacement::Deplacement() //constructeur
{
 
    this->mseconds=30;// temps pour la rotation une fois valeur trouvé ne pas changer
    posx=0;
    posy=0;
    this->vitesse=0.1; //pointeur this
}

void Deplacement::init(float val){
    m3piD.right_motor(val);
    m3piD.left_motor(val);
}

Deplacement::~Deplacement()
{
   
}
/////////////////////////////////////////////////////

void Deplacement::setVitesse(float v)
{
    this->vitesse=v; 
}

/////////////////////////////////////////////////////
    
void Deplacement::tourner_droite()
{
    int copie=0;
    
    m3piD.right(this->vitesse);
    wait(0.9);
    
    m3piD.stop();
    
    posx=copie;
    posx=posy;
    posy=-copie;
    
}
    
void Deplacement::tourner_gauche()
{
    int copie=0;
    
    m3piD.left(this->vitesse);
    wait(0.9);
    m3piD.stop();
    
    
    posx=copie;
    posx=-posy;
    posy=copie;

}

void Deplacement::avancer(float temps)
{
    m3piD.forward(this->vitesse);
    wait(temps);
    posy++;
    m3piD.stop();
}

void Deplacement::reculer(float temps)
{
    m3piD.right(this->vitesse);
    wait(1.8);
    m3piD.backward(this->vitesse);
    wait(temps);
    posy--;
    m3piD.stop();
}

void Deplacement::gauche(float temps){
    m3piD.left(this->vitesse);
    wait(0.9);
    avancer(temps);
}

void Deplacement::droite(float temps){
    m3piD.right(this->vitesse);
    wait(0.9);
    avancer(temps);
}

void Deplacement::stop()
{
    m3piD.stop();    
}

void Deplacement::RAZ()
{
    posx=0;   
    posy=0;
    this->vitesse=0;
   
} 

float Deplacement::getVitesse()
{
    return(this->vitesse);
}

int Deplacement::getPosX()
{ 
    return(this->posx);
}

int Deplacement::getPosY()
{   
    return(this->posy);
}

void Deplacement::tourner_droite_t()
{
    
    m3piD.left_motor(this->vitesse);
    m3piD.right_motor(-(this->vitesse));
}

void Deplacement::quartRotation(){
        m3piD.right(this->vitesse);
        wait(0.9);
        m3piD.stop();
}


    
    
   