#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"
#include "TS_DISCO_F429ZI.h"

#include "Capteurs.h"
#include "fonctions.h"
#include "automatique.h"
#include "commandes.h"


LCD_DISCO_F429ZI lcd;
//LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;
TS_StateTypeDef tsState;

int vol_y=145;
bool test=false;
bool indice_depart=false;
uint16_t x, y;

bool var_manuel=false;
bool var_automatique=false;



void initialisation(){
    lcd.Clear(LCD_COLOR_WHITE);
      
      
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(18,57,104,30);          //Rectangle calibrage
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.FillEllipse(65, 118, 45, 15);   //ellipse des modes
    lcd.FillRect(20, 180-35, 90, 40);    //Rectangle manuel
    lcd.FillRect(5, 230-35, 135, 40);    //Rectangle automatique
      
    //La vitesse :
    lcd.SetTextColor(LCD_COLOR_RED); 
    lcd.FillRect(200,80,2,180);
    lcd.SetTextColor(LCD_COLOR_BLACK); 
    lcd.FillRect(190,vol_y-15,20,30);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK); 
    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"V", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"I", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(9), (uint8_t *)"T", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"E", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"S", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(12), (uint8_t *)"S", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(13), (uint8_t *)"E", RIGHT_MODE);
    
    
    //Départ
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillEllipse(115, 292, 60, 23);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillEllipse(115, 292, 55, 20); 
      
      
    //Ecriture  
    
    lcd.SetTextColor(LCD_COLOR_WHITE); 
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.DisplayStringAt(20,67,(uint8_t *)"Calibrage",LEFT_MODE);
    lcd.SetBackColor(LCD_COLOR_RED); 
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Turbo Poparcalex2", CENTER_MODE);
   
    lcd.DisplayStringAt(45, LINE(7), (uint8_t *)"Mode", LEFT_MODE);
    lcd.DisplayStringAt(35, LINE(10), (uint8_t *)"Manuel", LEFT_MODE);
    lcd.DisplayStringAt(15, LINE(13), (uint8_t *)"Automatique", LEFT_MODE);
    
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, LINE(18), (uint8_t *)"Depart", CENTER_MODE);
    
    test=true;
    wait(0.1);}
    

void manuel(){
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(20, 180-35, 90, 40); 
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_BLACK); 
    lcd.DisplayStringAt(35, LINE(10), (uint8_t *)"Manuel", LEFT_MODE);
    var_manuel=true;
    
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.FillRect(5, 230-35, 135, 40); 
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE); 
    lcd.DisplayStringAt(15, LINE(13), (uint8_t *)"Automatique", LEFT_MODE);
    var_automatique=false;
    x=0;
    y=0;  }
    
    
void automatique(){
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.FillRect(20, 180-35, 90, 40); 
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE); 
    lcd.DisplayStringAt(35, LINE(10), (uint8_t *)"Manuel", LEFT_MODE);
    var_manuel=false;
    
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(5, 230-35, 135, 40); 
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_BLACK); 
    lcd.DisplayStringAt(15, LINE(13), (uint8_t *)"Automatique", LEFT_MODE);
    var_automatique=true; 
    x=0;
    y=0; }
    
    
void vitesse(){
    lcd.SetTextColor(LCD_COLOR_WHITE); 
    lcd.FillRect(190,vol_y-15,20,30);
    lcd.SetTextColor(LCD_COLOR_RED); 
    lcd.FillRect(200,80,2,180);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK); 
    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"V", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"I", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(9), (uint8_t *)"T", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"E", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"S", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(12), (uint8_t *)"S", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(13), (uint8_t *)"E", RIGHT_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK); 
    vol_y=y;
    lcd.FillRect(190,vol_y-15,20,30);  
    if(y>999){ y=y/10; }
    int valeur=((274.0-y)/(274.0-83))*99;
    uint8_t text[7];
    sprintf((char*)text, "%d  ", valeur);
        lcd.DisplayStringAt(0, LINE(4), (uint8_t *)&text, RIGHT_MODE);  
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"% ", RIGHT_MODE); 
    
    
    x=0;
    y=0; }
                

void depart(){
    lcd.Clear(LCD_COLOR_TRANSPARENT);
    lcd.SetBackColor(LCD_COLOR_TRANSPARENT);
    lcd.SetTextColor(LCD_COLOR_RED); 
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"3", CENTER_MODE);  
    wait(1);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"2", CENTER_MODE);  
    wait(1);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"1", CENTER_MODE);  
    wait(1);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"EN MARCHE", CENTER_MODE);  
    
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.FillCircle(120, 180-20, 100);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, 170-20, (uint8_t *)"STOP", CENTER_MODE);  
    wait(0.5);
    indice_depart=true; 
    x=0;
    y=0;  }
        
        
void stop(){
     lcd.Clear(LCD_COLOR_WHITE);
         
     lcd.SetBackColor(LCD_COLOR_RED);
     lcd.SetTextColor(LCD_COLOR_WHITE); 
     lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Turbo Poparcalex2", CENTER_MODE);
         
        //modes 
      lcd.SetTextColor(LCD_COLOR_RED);
      lcd.FillEllipse(65, 118, 45, 15);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(45, LINE(7), (uint8_t *)"Mode", LEFT_MODE);
      
        //vitesse
      lcd.SetTextColor(LCD_COLOR_RED); 
      lcd.FillRect(200,80,2,180);
      lcd.SetTextColor(LCD_COLOR_BLACK); 
      lcd.FillRect(190,vol_y-15,20,30);
      lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK); 
    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"V", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"I", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(9), (uint8_t *)"T", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"E", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"S", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(12), (uint8_t *)"S", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(13), (uint8_t *)"E", RIGHT_MODE);
    
    //Calibrage
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(18,57,104,30);
    lcd.SetTextColor(LCD_COLOR_WHITE); 
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.DisplayStringAt(20,67,(uint8_t *)"Calibrage",LEFT_MODE);
    
         
         //depart
       lcd.SetTextColor(LCD_COLOR_BLACK);
       lcd.FillEllipse(115, 292, 58, 23);
       lcd.SetTextColor(LCD_COLOR_GREEN);
       lcd.FillEllipse(115, 292, 55, 20); 
       lcd.SetBackColor(LCD_COLOR_GREEN);
       lcd.SetTextColor(LCD_COLOR_BLACK);
       lcd.DisplayStringAt(0, LINE(18), (uint8_t *)"Depart", CENTER_MODE);    
         
       if(var_manuel==true){
            manuel();}
            
       else if(var_automatique==true){
            automatique();}
       
       else{ 
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.FillRect(20, 180-35, 90, 40);    //Rectangle manuel
            lcd.FillRect(5, 230-35, 135, 40);    //Rectangle automatique
             
            lcd.SetBackColor(LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_WHITE);  
    
            lcd.DisplayStringAt(35, LINE(10), (uint8_t *)"Manuel", LEFT_MODE);
            lcd.DisplayStringAt(15, LINE(13), (uint8_t *)"Automatique", LEFT_MODE);}
        indice_depart=false;
        x=0;
        y=0;   }


void detection(){
     x = tsState.X;
        y = tsState.Y;
        uint8_t text[7];
        sprintf((char*)text, "%d; %d", x, y);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);   }





int main()
{      //screen_init();
    if(test==false){
        initialisation();}
    while(1){
        
    uint8_t status= ts.Init(lcd.GetXSize(), lcd.GetYSize());
    
        if(status != TS_OK){ erreur(); }

        ts.GetState(&tsState);   
        if(tsState.TouchDetected){
            detection();  }
    
    
        if((x<113 && x>13) && (y>189-35 && y<222-35) && indice_depart==false){
            manuel();}
       
        if((x<144 && x>2) && (y>240-35 && y<275-35) && indice_depart==false){
            automatique();}
       
        if((x<217 && x>193) && (y>81 && y<265) && indice_depart==false){
            vitesse();}
    
        if((x<182 && x>59) && (y>273 && y<318) && indice_depart==false){
            depart();
            
            if(var_automatique==true){
                    recup_vitesse(vol_y);
                    go_automatique();}
          //  else if(var_manuel==true){
          //          test=go_manuel();}}
            stop(); }
        
     /*   if((x<225 && x>12) && (y>78-20 && y<288-20) && indice_depart==true){
            stop();}
    */
    
    
    
        if((x<125 && x>10 ) && (y>61  && y<88) && indice_depart==false){
             calibrage();
             stop();}
    
    
        wait(0.05);
    
    
    
    }
}
