#include "screen.h"
/**
 * @brief global object for touchscreen events
*/
TS_StateTypeDef TS_State;

/**
* @fn void screen_init()
* @brief the screen_init function checks if the LCD Touch screen is ready to use
* @return nothing
*/
void screen_init()
{
    BSP_LCD_SetFont(&Font20);
    BSP_LCD_Init(); // Initializes the LCD
    BSP_LCD_LayerDefaultInit(0, (uint32_t) LCD_FRAME_BUFFER); // Initializes the LCD layers.*/
    BSP_LCD_SelectLayer(0); // Selects the LCD Layer
    BSP_LCD_SetLayerVisible(1, ENABLE); // Sets a LCD Layer visible
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_DisplayOn();
    uint8_t status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK)
    {
      BSP_LCD_Clear(LCD_COLOR_RED);
      BSP_LCD_SetBackColor(LCD_COLOR_RED);
      BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
      BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    }
    else
    {
      BSP_LCD_Clear(LCD_COLOR_GREEN);
      BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
      BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
      BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }
}

/**
 * @fn int isScreenTouched(void)
 * @brief questions whether the screen is touched or not
 * @return 1 if touched, 0 otherwise
**/
int isScreenTouched(){
    BSP_TS_GetState(&TS_State);
    if (TS_State.TouchDetected) {
        return 1;
    }
    return 0;
}

/**
* @fn void clearScreen()
* @brief the clearScreen function clears the screen and set a green background
* @return nothing
*/
void clearScreen(){
   BSP_LCD_Clear(LCD_COLOR_GREEN);
}

/**
* @fn void showIntegerScreen(int x, int nbline, int offset, Text_AlignModeTypdef mode)
* @brief the clearScreen function clears the screen and set a green background
* @param x: the integer to print on the LCD screen
* @param nbline: the line in which the number is to be printed
* @param offset: the offset with which the number is to be printed
* @param mode: the align mode
* @return nothing
*/
void showIntegerScreen(int x, int nbline, int offset, Text_AlignModeTypdef mode){
    TEXT t;
    sprintf((char *)t, "x=%d", x);
    BSP_LCD_DisplayStringAt(offset,LINE(nbline),(uint8_t*)"                              ",mode); //clears the line.
    BSP_LCD_DisplayStringAt(offset,LINE(nbline),(uint8_t*)&t,mode);
}

