#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"
#include "commandes.h"
#include "TS_DISCO_F429ZI.h"
#include <stdlib.h>
#include "screen.h"

typedef int tab[3];
int capteur1,capteur2,capteur3; //gauche, centre, droit
tab ligne;
float delai=1.0;


LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;
TS_StateTypeDef tsState;
uint16_t xa, ya;



void detectiona(){
    xa = tsState.X;
    ya = tsState.Y;
    int8_t text[7];
    sprintf((char*)text, "%d; %d", xa, ya);
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);   
}


void traitement(){
    if(capteur1==0 && capteur2==1 && capteur3==0){
        avancer();
        wait(delai);
    }
    else if(capteur1==1 && capteur2==0 && capteur3==0){
        tournerDroitVite();
        wait(delai);
    }
    else if(capteur1==1 && capteur2==1 && capteur3==0){
        tourner_droite();
        wait(delai);
    }
    else if(capteur1==0 && capteur2==0 && capteur3==1){
        tournerGaucheVite();
        wait(delai);
    }
    else if(capteur1==0 && capteur2==1 && capteur3==1){
        tourner_gauche();
        wait(delai);
    }
    else if(capteur1==1 && capteur2==1 && capteur3==1){
        arreter();
        wait(delai);
    }
}
        
int main(){

        uint8_t status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
        ts.GetState(&tsState); 
        detectiona();
        calibrage();

        
        while((xa>225 || xa<12) || (ya<78-20 || ya>288-20)){
            ts.GetState(&tsState); 
            detectiona();
            tab ligne=detectionLigne();
            capteur1=ligne[0];
            capteur2=ligne[1];
            capteur3=ligne[2];
            traitement();
            wait(delai);
            }
}


    
    
    
    
    