#include "calibrage.h"
#include "fonctions.h"


LCD_DISCO_F429ZI lcd2;
//LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts2;
TS_StateTypeDef tsState2;

AnalogIn capteur1(PF_6);
AnalogIn capteur2(PF_7);
AnalogIn capteur3(PF_8);



    uint16_t xc, yc;



void detectionc(){
     xc = tsState2.X;
        yc = tsState2.Y;
        uint8_t text[7];
        sprintf((char*)text, "%d; %d", xc, yc);
        lcd2.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);   }
        
        
        
        

void interface_noir(){
    lcd2.Clear(LCD_COLOR_WHITE);
    
    lcd2.SetTextColor(LCD_COLOR_BLUE);
    lcd2.FillRect(40,25,150,40);
    lcd2.SetBackColor(LCD_COLOR_BLUE);
    lcd2.SetTextColor(LCD_COLOR_WHITE);
    lcd2.DisplayStringAt(0, LINE(2), (uint8_t *)"Calibrage", CENTER_MODE);
    
    lcd2.SetBackColor(LCD_COLOR_WHITE);
    lcd2.SetTextColor(LCD_COLOR_BLACK);
    lcd2.DisplayStringAt(0, LINE(7), (uint8_t *)"Mesure du noir", CENTER_MODE);
    
    lcd2.SetTextColor(LCD_COLOR_BLUE);
    lcd2.FillCircle(120,235,50);
    lcd2.SetBackColor(LCD_COLOR_BLUE);
    lcd2.SetTextColor(LCD_COLOR_BLACK);
    lcd2.DisplayStringAt(0, 230, (uint8_t *)" OK", CENTER_MODE);
    }



void interface_blanc(){
    lcd2.Clear(LCD_COLOR_WHITE);
    
    lcd2.SetTextColor(LCD_COLOR_BLUE);
    lcd2.FillRect(40,25,150,40);
    lcd2.SetBackColor(LCD_COLOR_BLUE);
    lcd2.SetTextColor(LCD_COLOR_WHITE);
    lcd2.DisplayStringAt(0, LINE(2), (uint8_t *)"Calibrage", CENTER_MODE);
    
    lcd2.SetBackColor(LCD_COLOR_WHITE);
    lcd2.SetTextColor(LCD_COLOR_BLACK);
    lcd2.DisplayStringAt(0, LINE(7), (uint8_t *)"Mesure du blanc", CENTER_MODE);
    
    lcd2.SetTextColor(LCD_COLOR_BLUE);
    lcd2.FillCircle(120,235,50);
    lcd2.SetBackColor(LCD_COLOR_BLUE);
    lcd2.SetTextColor(LCD_COLOR_BLACK);
    lcd2.DisplayStringAt(0, 230, (uint8_t *)" OK", CENTER_MODE);
    }
    
void affichage(int* pointeur){
    lcd2.Clear(LCD_COLOR_WHITE);
    lcd2.SetBackColor(LCD_COLOR_WHITE);
    lcd2.SetTextColor(LCD_COLOR_BLACK);
    for(int i=0;i<3;i++){
    uint8_t text[7];
    sprintf((char*)text, "%d", *(pointeur+i));
        lcd2.DisplayStringAt(0, LINE(2*i), (uint8_t *)&text, LEFT_MODE); 
    
    }
    wait(2);
    }




int* calibrage(){
    uint8_t status2= ts2.Init(lcd2.GetXSize(), lcd2.GetYSize());

    ts2.GetState(&tsState2); 
    detectionc();
    wait(0.1);
    // Le but est de calculer une valeur qui servira de seuil pour savoir si le capteur est en face du noir ou du blanc, on travaille en analogique et on prend la valeur intermediaire pour chaque capteur 
    
    int * pointeur = (int*)malloc(3*sizeof(int));
    
    interface_noir();
        
    while((xc<72 || xc>172) || (yc>295 || yc<195)){
        ts2.GetState(&tsState2); 
        detectionc();
        wait(0.05);}
    
    int noir1=capteur1.read()*1000;
    int noir2=capteur2.read()*1000;
    int noir3=capteur3.read()*1000;
    
    wait(0.1);
    lcd2.Clear(LCD_COLOR_WHITE);
    lcd2.FillRect(50,50,150,50);
    lcd2.SetBackColor(LCD_COLOR_BLACK);
    lcd2.SetTextColor(LCD_COLOR_WHITE);
    lcd2.DisplayStringAt(0, LINE(4), (uint8_t *)"Next ->", CENTER_MODE);
    
    while((xc<47 || xc>205) || (yc>100 || yc<50)){
        ts2.GetState(&tsState2); 
        detectionc();
        wait(0.05);}
    
    wait(0.01); 
    interface_blanc();
    
     while((xc<72 || xc>172) || (yc>295 || yc<195)){
        ts2.GetState(&tsState2); 
        detectionc();
        wait(0.05);}
    
    int blanc1=capteur1.read()*1000;
    int blanc2=capteur2.read()*1000;
    int blanc3=capteur3.read()*1000;
    

    
    *pointeur=(blanc1+noir1)/2;
    *(pointeur+1)=(blanc2+noir2)/2;
    *(pointeur+2)=(blanc3+noir3)/2;
    
    affichage(pointeur);
    
    
    
    
    
    return(pointeur);
    
    }