#ifndef MAIN_H
#define MAIN_H
/******************************************************** 
* INCLUDES 
********************************************************/
#include "mbed.h"          
#include "rtos.h"
#include <iostream>
#include <vector>
  
 /******************************************************** 
* DEFINES 
********************************************************/ 

  
#define DELAY           0.5 
  
#define MMA8452_WRITE_ADDRESS 0x3A 
#define MMA8452_READ_ADDRESS  0x3B 
#define WHO_AM_I        0x0D 
#define OUT_X_MSB       0x01 
#define OUT_X_LSB       0x02 
#define OUT_Y_MSB       0x03 
#define OUT_Y_LSB       0x04 
#define OUT_Z_MSB       0x05 
#define OUT_Z_LSB       0x06 
#define CTRL_REG1       0x2A  
#define CTRL_REG2       0x2B 
#define XYZ_DATA_CFG    0x0E 

/******************************************************** 
* VARIABLE GLOBALE
********************************************************/ 


/******************************************************** 
* PROTOTYPE FONCTION ACCELERO
********************************************************/ 
void WriteToRegister(int address, int startingRegister, int data2Write);
int ReadRegister(int address, int startingRegister);
char i2c_read_reg(char address) ;
bool initAccel();
unsigned short getAccelValue(char MSB_addr);



/******************************************************** 
* THREADS
********************************************************/ 
void collector_thread(void const *args);
  
  
#endif