/*!
 *  \file trame.h
 *  \brief Class that send command with the xbee
 *  \author Equipe P02
 *  \version 1
 *  \date 02/04/2014
 */
 
 #ifndef TRAME_H
#define TRAME_H

#include "mbed.h"

using namespace std;

/*! 
 *  \class Trame trame.h "trame.h"
 *  \brief Class that send data with the xbee
 */
class Trame
{
public:

    /*!
     *  \brief Constructor
     *  \param _tx PinName for tx
     *  \param _rx PinName for rx
     */
    Trame(PinName _tx, PinName _rx);  
    
    /*!
     *  \brief Send a transmit request
     *  \param destination Destination of the request
     *  \param data Data to send
     *  \param lenght Lenght of the data
     */ 
    void sendTransmitRequest(const char* destination, const char* data, int length);
    
private:
    /*!
     *  \brief Calculate checksum 8
     *  \param data Data for checksum
     *  \param lenght Lenght of the data
     */ 
    unsigned char crc8(const char* data, int length);

    PinName tx, rx;
};

#endif