/*!
 *  \file mouvement.cpp
 *  \brief Class that send mouvement and contain a definition
 *  \author Equipe P02
 *  \version 1
 *  \date 9/04/2014
 */
 
#ifndef MOUVEMENT_H
#define MOUVEMENT_H

#include "trame.h"
#include <string>

using namespace std;

/*! 
 *  \class Mouvement mouvement "mouvement.h"
 *  \brief Class define a mouvement and send a code in xbee
 */
class Mouvement
{
public:
    /*!
     *  \brief Constructor
     *  \param code Code to find mouvement
     *  \param code_envoie Code to send in xbee
     *  \param definition Definition of the mouvement
     *  \param h The hand true = left false = right
     */
    Mouvement(short code, short code_envoie, string definition, bool h);
    
    /*!
     * \brief Get definition
     * \return _definition
     */
    string definition() const { return _definition; }
    
    /*!
     *  \brief Construct data in char* and send this
     *  \param trame Trame the send in xbee
     */
    void sendData(Trame *trame);
    
private:
    short _code; /*!< Code that define mouvement */
    short _code_envoie; /*!< Code that send in xbee */
    string _definition; /*!< Definition of the mouvement */
    bool hand; /*!< The hand use */
};

#endif
