#include "mouvement.h"

Mouvement::Mouvement(short code, short code_envoie, string definition, bool h) :
    _code(code),
    _code_envoie(code_envoie),
    _definition(definition),
    hand(h)
{
}

void Mouvement::sendData(Trame *trame)
{
    char code[4];
    
    code[0] = hand ? 0x1 : 0x0;             // Hand
    code[1] = (_code_envoie >> 8) & 0xF;    // Code to send msb
    code[2] = (_code_envoie >> 4) & 0xF;    // Code to send
    code[3] = _code_envoie & 0xF;           // Code to send lsb
     
    const char destination[8] = {0};    // Destination Null
    
    trame->sendTransmitRequest(destination, code, sizeof(int)); // Trasmit code
}
