/*!
 *  \file analyzer.cpp
 *  \brief Class that analyzes the mouvement in C and C++
 *  \author Equipe P02
 *  \version 0.1
 *  \date 02/04/2014
 */

#include "analyzer.h"
 
Analyzer::Analyzer()
{
}
 
Analyzer::~Analyzer()
{
    allMouvement.clear();
}

void Analyzer::initialize()
{
    DigitalOut reset(p8);
    
    reset = 0;
    wait(0.4);  // Reset xbee
    reset = 1;
    
    trame = new Trame(p13, p14);
    
    allMouvement[0x0002] = new Mouvement(0x0002, 0x0002, "Z vertical, vers le ciel", hand);
    allMouvement[0x0003] = new Mouvement(0x0003, 0x0003, "Z vertical, vers le ciel INVERSE", hand);
    allMouvement[0x0004] = new Mouvement(0x0004, 0x0004, "Z vertical, vers le sol", hand);
    allMouvement[0x0005] = new Mouvement(0x0005, 0x0005, "Z vertical, vers le sol INVERSE", hand);
    allMouvement[0x0006] = new Mouvement(0x0006, 0x0006, "Z horizontal", hand);
    allMouvement[0x0007] = new Mouvement(0x0007, 0x0007, "Z horizontal INVERSE", hand);

    allMouvement[0x0020] = new Mouvement(0x0020, 0x0020, "X vertical, vers le ciel", hand);
    allMouvement[0x0030] = new Mouvement(0x0030, 0x0030, "X vertical, vers le ciel INVERSE", hand);
    allMouvement[0x0040] = new Mouvement(0x0040, 0x0040, "X vertical, vers le sol", hand);
    allMouvement[0x0050] = new Mouvement(0x0050, 0x0050, "X vertical, vers le sol INVERSE", hand);
    allMouvement[0x0060] = new Mouvement(0x0060, 0x0060, "X horizontal", hand);
    allMouvement[0x0070] = new Mouvement(0x0070, 0x0070, "X horizontal INVERSE", hand);

    allMouvement[0x0200] = new Mouvement(0x0200, 0x0200, "Y vertical, vers le ciel", hand);
    allMouvement[0x0300] = new Mouvement(0x0300, 0x0300, "Y vertical, vers le ciel INVERSE", hand);
    allMouvement[0x0400] = new Mouvement(0x0400, 0x0400, "Y vertical, vers le sol", hand);
    allMouvement[0x0500] = new Mouvement(0x0500, 0x0500, "Y vertical, vers le sol INVERSE", hand);
    allMouvement[0x0600] = new Mouvement(0x0600, 0x0600, "Y horizontal", hand);
    allMouvement[0x0700] = new Mouvement(0x0700, 0x0700, "Y horizontal INVERSE", hand);
}
 
void Analyzer::setMinMax(signed char* values)
{
    x.setMinMax(values[0]);
    y.setMinMax(values[1]);
    z.setMinMax(values[2]);
}
 
void Analyzer::checkMouvement()
{
    bool deplacement[3] = {0};
    int code_mouvement = 0;
    
    deplacement[0] = x.isMouvement();
    deplacement[1] = y.isMouvement();          
    deplacement[2] = z.isMouvement();  
       
    // Mouvement en x
    if(deplacement[0])
    {
        if(x.initial > SEUIL_DETECTION)
        {
            code_mouvement |= 0x1 << 9; // 0010
        }
        else if(x.initial < -SEUIL_DETECTION)
        {       
            code_mouvement |= 0x2 << 9; // 0100
        }
        else
        {
            code_mouvement |= 0x3 << 9; // 0110
        }
        
        if(!x.sens)
        {
            code_mouvement |= 0x1 << 8; // 0xx1 
        }
    }
    
    // Mouvement en y  
    if(deplacement[1])
    {
        if(y.initial > SEUIL_DETECTION)
        {
            code_mouvement |= 0x1 << 5; // 0xxx 0010
        }
        else if(y.initial < -SEUIL_DETECTION)
        {
            code_mouvement |= 0x2 << 5; // 0xxx 0100
        }
        else
        {
            code_mouvement |= 0x3 << 5; // 0xxx 0110
        }
        
        if(!y.sens)
        {
            code_mouvement |= 0x1 << 4; // 0xxx 0yy1 
        }
    }
    
    // Mouvement en z
    if(deplacement[2])
    {
        if(z.initial > SEUIL_DETECTION)
        {
            code_mouvement |= 1 << 1; // 0xxx 0yyy 0010
        }
        else if(z.initial < -SEUIL_DETECTION)
        {
            code_mouvement |= 2 << 1; // 0xxx 0yyy 0100
        }
        else
        {
            code_mouvement |= 3 << 1; // 0xxx 0yyy 0110
        }
        
        if(!z.sens)
        {
            code_mouvement |= 1 << 0; // 0xxx 0yyy 0zz1
        }
    }

    map<int,Mouvement*>::iterator it;
    it = allMouvement.find(code_mouvement);
                                           
    if(it != allMouvement.end())
        it->second->sendData(trame);
}

void Analyzer::setInitial(signed char* init)
{
    x.setInitial(init[0]);
    y.setInitial(init[1]);
    z.setInitial(init[2]);
}
 
extern "C" void *Analyzer_C_new()
{
    return new Analyzer();
}
 
extern "C" void Analyzer_C_delete(void *analyzer)
{
    Analyzer *an = (Analyzer*)analyzer;
    delete an;    
}

extern "C" void Analyzer_C_Initialize(void *analyzer)
{
    Analyzer *an = (Analyzer*)analyzer;
    an->initialize();
}
 
extern "C" void Analyzer_C_setMinMax(signed char* values, void *analyzer)
{
    Analyzer *an = (Analyzer*)analyzer;
    an->setMinMax(values);    
}
 
extern "C" void Analyzer_C_setInitial(signed char* init, void *analyzer)
{
    Analyzer *an = (Analyzer*)analyzer;
    an->setInitial(init);    
}
 
extern "C" void Analyzer_C_checkMouvement(void *analyzer)
{
    Analyzer *an = (Analyzer*)analyzer;
    an->checkMouvement();
}

extern "C" void Analyzer_C_setHand(bool h, void *analyzer)
{
    Analyzer *an = (Analyzer*)analyzer;
    an->setHand(h);
}
