/*!
 *  \file accelerometer.h
 *  \brief Class that define a accelerometer in C and C++
 *  \author Equipe P02
 *  \version 1.0
 *  \date 14/03/2014
 */

#ifndef ACCELERATOR_H
#define ACCELERATOR_H

#include "mbed.h"

/******************************************************** 
* DEFINES 
********************************************************/ 
  
#define DELAY           0.5 
  
#define MMA8452_WRITE_ADDRESS 0x3A 
#define MMA8452_READ_ADDRESS  0x3B 
#define WHO_AM_I        0x0D 
#define OUT_X_MSB       0x01 
#define OUT_X_LSB       0x02 
#define OUT_Y_MSB       0x03 
#define OUT_Y_LSB       0x04 
#define OUT_Z_MSB       0x05 
#define OUT_Z_LSB       0x06 
#define CTRL_REG1       0x2A  
#define CTRL_REG2       0x2B 
#define XYZ_DATA_CFG    0x0E 

/*! 
 *  \class Accelerometer acceleromter.h "accelerometer.h"
 *  \brief Class that define a accelerometer
 *
 *  Class in C++ to activate en read information of accelerometer
 */
class Accelerometer
{
public:

    /*!
     *  \brief Constructor
     */
    Accelerometer();
    
    /*!
     *  \brief Destructor
     */
    ~Accelerometer();
    
    /*!
    *   \brief Read data of the accelerometer
    *   \return Array of axe x, y, z in signed char
    */
    signed char* getAccelValue();
    
private:

    /*!
    *   \brief Write data in a specific register
    * 
    *   \param address Address to write
    *   \param startingRegister Starting address to write
    *   \param data2Write Data to write
    */
    void writeToRegister(int address, int startingRegister, int data2Write);
    
    /*!
    *   \brief Read register
    * 
    *   \param address Address to read
    *   \return The value read
    */
    char readRegister(char address);
    
    /*!
    *   \brief Initialise Accelerometer
    *
    *   \return True if initialition ok
    */
    bool initAccel();
    
    I2C i2c; /*!< I2C port (sda, scl) */
};

// Define function in C for interruption
// The C function call C++ function
#ifdef __cplusplus
extern "C" {
#endif

extern void *Accelerometer_C_new(); /*!< Call Constructor \see Accelerometer() */
extern void  Accelerometer_C_delete(void *accelerometer); /*!< Call Destructor \see ~Accelerometer() */
extern signed char* Accelerometer_C_getAccelValue(void *accelerometer); /*!< Call getAccelValue \see getAccelValue() */

#ifdef __cplusplus
}
#endif
    
#endif