/*!
 *  \file accelerometer.cpp
 *  \brief Class that define a accelerometer in C and C++
 *  \author Equipe P02
 *  \version 1.0
 *  \date 14/03/2014
 */

#include "accelerometer.h"

Accelerometer::Accelerometer() :
    i2c(p9, p10)
{
    initAccel();    
}

Accelerometer::~Accelerometer(){}

void Accelerometer::writeToRegister(int address, int startingRegister, int data2Write) 
{ 
    char data[2]; 
    data[0] = startingRegister; 
    data[1] = data2Write; 

    i2c.write(address, data, 2); 
}
  
char Accelerometer::readRegister(char address) //fonction qui lit les valeurs des registres 
{    
    // Read from selected register adress 
    i2c.start();                                          
    i2c.write(MMA8452_WRITE_ADDRESS);    
    i2c.write(address);                  
    i2c.start();                         
    i2c.write(MMA8452_READ_ADDRESS);     
    char data = i2c.read(0);             
    i2c.stop();                          
   
    // return the data readed 
    return data;    
} 
  
bool Accelerometer::initAccel() //fonction qui initialise l'Accelerometer avec i2c 
{ 
    // Start I2C communication    
    char data = readRegister(WHO_AM_I); 
    if(data != 0x2A) 
    { 
        return false; 
    }
    
    // Put accelerometer in active mode at 6.25Hz 
    writeToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x31); 
      
    // Put accelerometer in standby mode at 6.25Hz 
    writeToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x30); 
       
    // Set accelerometer in 4g range 
    writeToRegister(MMA8452_WRITE_ADDRESS, XYZ_DATA_CFG, 0x1); 
       
    // Put accelerometer in active mode at 6.25Hz 
    writeToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x31);
    
    return true;      
}

signed char* Accelerometer::getAccelValue()
{
    // Signed char to have values in -128 and 128
    // The base char is in unsigned
    signed char* values = new signed char[3]; 
    
    values[0] = readRegister(OUT_X_MSB); // data x
    values[1] = readRegister(OUT_Y_MSB); // data y
    values[2] = readRegister(OUT_Z_MSB); // data z
    
    return values;
} 

extern "C" void *Accelerometer_C_new()
{
    return new Accelerometer();
}

extern "C" void Accelerometer_C_delete(void *accelerometer)
{
    Accelerometer *acc = (Accelerometer*)accelerometer;
    delete acc;
}

extern "C" signed char* Accelerometer_C_getAccelValue(void *accelerometer)
{
    Accelerometer *acc = (Accelerometer*)accelerometer;
    return acc->getAccelValue();
}
  