#include "mbed.h"

AnalogIn analog_value(A0);
AnalogOut sortie(D7);
Timer Chronometre;
Ticker interruption;

float amplitude;
DigitalOut led(LED1);

void signal_de_sortie() {
        sortie = (float) (0.5+amplitude*sin(Chronometre.read()*314));
    }

int main()
{
    Chronometre.start();
    float meas_r;
    float meas_v;
    unsigned int valeur_numerique;
    interruption.attach(&signal_de_sortie, 0.001);   // exécute la fonction 1000 x par secondes
    
    printf("\nAnalogIn example\n");

    while(1) {

        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_v = meas_r * 3300; // Converts value in the 0V-3.3V range
        valeur_numerique = analog_value.read_u16();
        
        // Display values
        printf("measure = %d = %f = %.0f mV\n", valeur_numerique, meas_r, meas_v);

//        sortie = meas_r;
        amplitude = meas_r / 2;

        // LED is ON is the value is below 1V
        if (meas_v < 1000) {
            led = 1; // LED ON
        } else {
            led = 0; // LED OFF
        }

        wait(1.0); // 1 second
    }
}
