#include "mbed.h"

#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"
#include "DmTftRa8875.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/* Note that there are restrictions on which platforms that can use printf
   in combinations with the DmTftLibrary. Some platforms (e.g. LPC1549 LPCXpresso)
   use the same pins for USBRX/USBTX and display control. Printing will
   cause the display to not work. Read more about this on the display's notebook
   page. */
#define log(...) printf(__VA_ARGS__)
//#define log(...)

/******************************************************************************
 * Local variables
 *****************************************************************************/

//DmTftHX8353C tft(D2, D3, D4, D5, D6);  /* DmTftHX8353C(PinName mosi, PinName clk, PinName cs, PinName dc, PinName rst) DM_TFT18_101 */
//DmTftS6D0164 tft(A4, A3, A5, A2);  /* DmTftS6D0164(PinName wr, PinName cs, PinName dc, PinName rst) DM_TFT22_102 */
//DmTftIli9325 tft(A4, A3, A5, A2);  /* DmTftIli9325(PinName wr, PinName cs, PinName dc, PinName rst) DM_TFT28_103 and DM_TFT24_104 */
DmTftIli9341 tft(D10, D12, D11, D12, D13);  /* DmTftIli9341(PinName cs, PinName dc, PinName mosi, PinName miso, PinName clk)  DM_TFT28_105 */
//DmTftSsd2119 tft(D10, D9, D11, D12, D13);  /* DmTftSsd2119(PinName cs, PinName dc, PinName mosi, PinName miso, PinName clk) DM_TFT35_107 */
//DmTftRa8875  tft(D10, D9, D11, D12, D13);  /* DmTftRa8875(PinName cs, PinName sel, PinName mosi, PinName miso, PinName clk) DM_TFT43_108 and DM_TFT50_111   For DmTftRa8875 driver, The panel resolution should be config in DmTftRa8875::init() function on the DmTftRa8875.cpp file. */

int bmpWidth, bmpHeight;
uint8_t bmpImageoffset;

/******************************************************************************
 * Global variables
 *****************************************************************************/

extern uint8_t dmlogo[];

/******************************************************************************
 * Local functions
 *****************************************************************************/

// LITTLE ENDIAN!
uint16_t read16(uint8_t *src)
{
  uint16_t d;
  uint8_t b;
  b = *src;
  d = *(src+1);
  d <<= 8;
  d |= b;
  return d;
}

// LITTLE ENDIAN!
uint32_t read32(uint8_t *src)
{
  uint32_t d;
  uint16_t b;

  b = read16(src);
  d = read16(src+2);
  d <<= 16;
  d |= b;
  return d;
}

void drawBmpFromFlash(int x, int y)
{
  uint16_t pos = bmpImageoffset;

  uint16_t p;  // pixel
  uint8_t g, b;
  int i, j; // line, column

  for(i=bmpHeight; i>0; i--) {
    for(j=0; j<bmpWidth; j++) {
      b = *(dmlogo+pos++);
      g = *(dmlogo+pos++);
      p = *(dmlogo+pos++);

      p >>= 3;
      p <<= 6;

      g >>= 2;
      p |= g;
      p <<= 5;

      b >>= 3;
      p |= b;

      // write out the 16 bits of color
      tft.setPixel(j, i+y, p);
    }
  }
}


int bmpReadHeader() {
  uint32_t fileSize;
  uint32_t headerSize;
  uint16_t bmpDepth;
  uint16_t pos = 0;
  log("reading bmp header\r\n");
  log("Magic byte is: %d \r\n", read16(dmlogo));

  if (read16(dmlogo) !=0x4D42){ // read magic byte
    log("Magic byte not found\r\n");
    return false;
  }
  pos += 2;

  // read file size
  fileSize = read32(dmlogo+pos);
  log("filesize is: %d \r\n", fileSize);
  log("");
  pos += 4;

  pos += 4; // Skip creator bytes

  bmpImageoffset = read32(dmlogo+pos);
  pos += 4;

  // read DIB header
  headerSize = read32(dmlogo+pos);
  pos +=4;
  bmpWidth = read32(dmlogo+pos);
  pos += 4;
  bmpHeight = read32(dmlogo+pos);
  pos += 4;

  log("Image size:        %d\r\n", fileSize);
  log("Image offset:      %d\r\n", bmpImageoffset);
  log("Header size:       %d\r\n", headerSize);
  log("Image width:       %d\r\n", bmpWidth );
  log("Image height:      %d\r\n", bmpHeight );

  if (read16(dmlogo+pos) != 1){
    // number of color planes must be 1
    return false;
  }
  pos += 2;

  bmpDepth = read16(dmlogo+pos);
  pos +=2;
  log("Bitdepth:          %d\r\n", bmpDepth);

  if (read16(dmlogo+pos) != 0) {
    // compression not supported!
    return false;
  }
  pos += 2; // Should really be 2??

  return true;
}

/******************************************************************************
 * Main
 *****************************************************************************/

int main() {
  log("init tft \r\n");
  tft.init();

  tft.drawString(0,00,"                ");  
  tft.drawString(0,16,"                ");
  tft.drawString(0,32,"Bonjour,        ");
  tft.drawString(0,48,"je suis cubya!  ");
  tft.drawString(0,64,"Que faites vous?");
  tft.drawString(0,80,"Je suis la pour ");
  tft.drawString(0,96,"vous aider.     ");
  tft.drawString(0,112,"Comment        ");
  tft.drawString(0,128,"allez-vous ?   ");
  tft.drawString(0,144,"               ");


  if (! bmpReadHeader()) {
    log("bad bmp\r\n");
    return -1;
  }

  

  while(1) {
  }
}