#include "mbed.h"
#include "rtos.h"
#include "main.hpp"

//------------------------ MAIN ------------------------
bool infosDebug = true;
bool readOrWriteMode = READ_MODE;
DigitalOut myled(LED1);
Serial debugPC(USBTX, USBRX);   // tx, rx   //Communication pour le debug entre le PC et le mbed

//------------------------ RFID ------------------------
//Variables globales
struct DonneesTag structDonneesTag;
struct DataTrame strucTrameRx;
Serial comRFID(p13, p14);       // tx, rx   //Communication entre le mbed et le RFID SM130
volatile bool frameRxComplete = false;


//Main
int main() {
    //Initialisation
    //debugPC.baud(19200);
    
    
    debugPC.printf("\n\n\n\rAttente 2 secondes...");
    wait(2);    //Attente démarrage du mbed
    debugPC.printf("\n\rHello World!\n");
    
    //Activations des taches
    Thread tache1(threadRFID);  
    
    while(1) {
        flashingLED();
    }
}
//------------------------ MAIN ------------------------
void flashingLED() {
    myled = 1;
    wait(1);
    myled = 0;
    wait(0.5);
} 

void threadRFID(void const *args) {
    unsigned char static state = SET_RESET, stateTAG = SEEK;
    unsigned char tabDataTx[25];
    unsigned int valRetour;
    
    struct InfosTag structInfosTag;
    
    
    
    while(1) {
        switch (state){
            case SET_RESET :
                if(infosDebug == true)
                    debugPC.printf("\n\rCase SET_RESET");
                TxFrame(RESET, 0x00, tabDataTx);        
                //if(comRFID.readable() == 1){
                //    valRetour = RxFrame((unsigned char*) &strucTrameRx);
                debugPC.printf("\n\r\t\t\tframeRxComplete0 = %02x", frameRxComplete);
                while(frameRxComplete == false);
                debugPC.printf("\n\r\t\t\tframeRxComplete1 = %02x", frameRxComplete);
                frameRxComplete = false;
                //if((valRetour == 0) & (strucTrameRx.command == FIRMWARE))   //Response for reset = command response FIRMWARE
                if(strucTrameRx.command == FIRMWARE)  //Response for reset = command response FIRMWARE
                    state = SET_ANTENNA_POWER;
                break;
                
            case SET_ANTENNA_POWER :
                if(infosDebug == true)
                    debugPC.printf("\n\rCase SET_ANTENNA_POWER");
                tabDataTx[0] = ANTENNA_SWITCH_ON;
                TxFrame(ANTENNA_POWER, 0x01, tabDataTx);        
                //if(comRFID.readable() == 1){
                //    valRetour = RxFrame((unsigned char*) &strucTrameRx);
                while(frameRxComplete == false);
                frameRxComplete = false;
                //if((valRetour == 0) & (strucTrameRx.command == ANTENNA_POWER) & (strucTrameRx.data[0] == ANTENNA_SWITCH_ON)){
                if((strucTrameRx.command == ANTENNA_POWER) & (strucTrameRx.data[0] == ANTENNA_SWITCH_ON)){
                    state = READ_TAG;
                    stateTAG = SEEK;
                }
                break;
                
            case READ_TAG :
                if(infosDebug == true)
                    debugPC.printf("\n\rCase READ_TAG");
                
                switch (stateTAG){
                    case SEEK :
                        if(infosDebug == true)
                            debugPC.printf("\tSEEK");
                        TxFrame(SEEK_FOR_TAG, 0x00, tabDataTx);        
                        if(comRFID.readable() == 1){
                            valRetour = RxFrame((unsigned char*) &strucTrameRx);
                            if((valRetour == 0) & (strucTrameRx.command == SEEK_FOR_TAG)){
                                if((strucTrameRx.length == 0x02) & (strucTrameRx.data[0] == 0x55)){
                                    state = SET_ANTENNA_POWER;
                                    stateTAG - SEEK;
                                }
                                else if(strucTrameRx.length == 0x06){
                                    structInfosTag.tagType = strucTrameRx.data[0];
                                    for(unsigned int cpt = 1; cpt < strucTrameRx.length - 1; cpt++)
                                        structInfosTag.serialNumber[cpt-1] = strucTrameRx.data[cpt];
                                    stateTAG = AUTHENTI;
                                }
                            }
                        }
                        break;
                    
                    case AUTHENTI :
                        if(infosDebug == true)
                            debugPC.printf("\tAUTHENTI");
                        tabDataTx[0] = 0x01;
                        tabDataTx[1] = 0xFF;
                        TxFrame(AUTHENTICATE, 0x02, tabDataTx);        
                        if(comRFID.readable() == 1){
                            valRetour = RxFrame((unsigned char*) &strucTrameRx);
                            if((valRetour == 0) & (strucTrameRx.command == AUTHENTICATE)){
                                if(strucTrameRx.data[0] == 0x4C){   //Login Successful
                                    if(readOrWriteMode == READ_MODE)
                                        stateTAG = READ;
                                    else if (readOrWriteMode == WRITE_MODE)
                                        stateTAG = WRITE;
                                }
                                else 
                                    stateTAG = SEEK;
                            }
                            else 
                                stateTAG = SEEK;
                        }
                        break;
                    
                    case READ :
                        if(infosDebug == true)
                            debugPC.printf("\tREAD");
                        tabDataTx[0] = 0x00;
                        TxFrame(READ_BLOCK, 0x01, tabDataTx);        
                        if(comRFID.readable() == 1){
                            valRetour = RxFrame((unsigned char*) &strucTrameRx);
                            if((valRetour == 0) & (strucTrameRx.command == READ_BLOCK)){
                                if(strucTrameRx.length == 0x12){   //Read SUCCESS
                                    if(infosDebug == true)
                                        debugPC.printf("\tSUCCESS");
                                    //on recupere les données du tag
                                    structDonneesTag.typeTrajet = strucTrameRx.data[0];
                                    structDonneesTag.direction = strucTrameRx.data[1];
                                    structDonneesTag.distance = strucTrameRx.data[2];
                                    structDonneesTag.position = strucTrameRx.data[4];
                                    if(infosDebug == true){
                                        debugPC.printf("\r\nTypeTrajet :\t%02x", strucTrameRx.data[0]);
                                        debugPC.printf("\r\nDirection :\t%02x", strucTrameRx.data[1]);
                                        debugPC.printf("\r\nDistance :\t%02x", strucTrameRx.data[2]);
                                        debugPC.printf("\r\nPosition :\t%02x", strucTrameRx.data[4]);
                                    }
                                }
                                else {
                                    if(infosDebug == true)
                                        debugPC.printf("\tFAIL");
                                }
                            }
                        }
                        stateTAG = SEEK;
                        break;
                        
                    case WRITE :
                        if(infosDebug == true)
                            debugPC.printf("\tWRITE");
                            
                        tabDataTx[0] = 0x01;    //TYPE DE TRAJET
                        tabDataTx[1] = 0x00;    //Direction
                        tabDataTx[2] = 0x02;    //Distance
                        tabDataTx[3] = 0x00;    //Reserved
                        tabDataTx[4] = 0x05;    //Position
                        tabDataTx[5] = 0x00;
                        tabDataTx[6] = 0x00;
                        tabDataTx[7] = 0x00;
                        tabDataTx[8] = 0x00;
                        tabDataTx[9] = 0x00;
                        tabDataTx[10] = 0x00;   //Version
                        tabDataTx[11] = 0x02;   //Type carte
                        tabDataTx[12] = 'C';
                        tabDataTx[13] = 'R';
                        tabDataTx[14] = 'I';
                        tabDataTx[15] = 'C';
                        TxFrame(WRITE_BLOCK, 0x0F, tabDataTx);        
                        if(comRFID.readable() == 1){
                            valRetour = RxFrame((unsigned char*) &strucTrameRx);
                            if((valRetour == 0) & (strucTrameRx.command == WRITE_BLOCK)){
                                if(strucTrameRx.length == 0x12){   //Read SUCCESS
                                    if(infosDebug == true)
                                        debugPC.printf("\tSUCCESS");
                                    //on recupere les données du tag
                                    structDonneesTag.typeTrajet = strucTrameRx.data[0];
                                    structDonneesTag.direction = strucTrameRx.data[1];
                                    structDonneesTag.distance = strucTrameRx.data[2];
                                    structDonneesTag.position = strucTrameRx.data[4];
                                    if(infosDebug == true){
                                        debugPC.printf("\r\nTypeTrajet :\t%02x", strucTrameRx.data[0]);
                                        debugPC.printf("\r\nDirection :\t%02x", strucTrameRx.data[1]);
                                        debugPC.printf("\r\nDistance :\t%02x", strucTrameRx.data[2]);
                                        debugPC.printf("\r\nPosition :\t%02x", strucTrameRx.data[4]);
                                    }
                                }
                                else {
                                    if(infosDebug == true)
                                        debugPC.printf("\tFAIL");
                                }
                            }
                        }
                        stateTAG = SEEK;
                        break;
                }
                break;
        }
        Thread::wait(50);
    }
}

//------------------------ RFID ------------------------
void TxFrame(unsigned char command, unsigned char lengthData, unsigned char *dataTx){
    unsigned int cpt = 0;
    unsigned char csum = 0;
    
    lengthData += 1;    // +1 pour ajout taille commande
    csum = calcCSUM(command, lengthData, dataTx);
    
    comRFID.putc(0xFF);                         //HEADER
    comRFID.putc(0x00);                         //RESERVED
    comRFID.putc(lengthData );                  //LENGTH
    comRFID.putc(command);                      //COMMAND
    for(cpt = 0; cpt<lengthData-1; cpt++){      //DATA
        comRFID.putc(*(dataTx+cpt));         
    }
    comRFID.putc(csum);                         //CSUM
    
    //Affiche debug __________________________________________
    if(infosDebug == true){
        debugPC.printf("\n\r\tTx :");
        debugPC.printf("FF ");
        debugPC.printf("00 ");
        debugPC.printf("%02x ", lengthData );                          
        debugPC.printf("%02x ", command);   
        for(cpt = 0; cpt<lengthData-1; cpt++)
            debugPC.printf("%02x ", *(dataTx+cpt));  
        debugPC.printf("%02x ", csum);    
    }
}

unsigned int RxFrame(unsigned char *dataRx){
    unsigned char command, length, csumRx, csumCalc;
    
    if(infosDebug == true)
        debugPC.printf("\n\r\tRx : ");
    
    for(unsigned int cpt = 0; comRFID.readable() == 1; cpt++){      //Ajouter un TIMEOUT
        dataRx[cpt] = comRFID.getc();
    }
    
    command = *(dataRx + 3);
    length = *(dataRx + 2);
    csumRx = *(dataRx + 3 + length);
    
    //Verification HEADER
    if(*(dataRx + 0) != HEADER)
        return 1;
    
    //Verification RESERVED    
    if(*(dataRx + 1) != RESERVED)
        return 1;
      
    //Verification csum
    csumCalc = calcCSUM(command, length, (dataRx + 4));
    if(csumCalc != csumRx)
        return 1;
        
    if(infosDebug == true){
        for(unsigned int cpt = 0; cpt < length + 4; cpt++)
            debugPC.printf("%02x ", dataRx[cpt]);
    }
    return 0;
}

void RxFrameInterrupt() {
    static unsigned char cptDataRxFrame = 0;    //Compteur du nombres octets recu sur la liaison
    static unsigned char stateRxFrame = 1;      //Variable etat permetant de valider chaque octet d'une trame recue
    unsigned char byteRx;
    
    byteRx = comRFID.getc();                    //Variable qui stocke chaque octet recu
    debugPC.printf("\n\rINTERRUPT");
    
    switch (stateRxFrame) {
        case 0 :
            if(frameRxComplete == false)
                stateRxFrame = 1;
            break;
        
        case 1 :
            if (byteRx == HEADER)               //Attente et vérification de la réception du HEADER
                stateRxFrame = 2;    
            break;
        
        case 2 :
            if (byteRx == RESERVED)
                stateRxFrame = 3;               //Réception et vérification du RESERVED
            break;
        
        case 3 :
            strucTrameRx.length = byteRx;       //Reception LENGTH
            stateRxFrame = 4;
            break;
        
        case 4 :
            strucTrameRx.command = byteRx;      //Reception COMMAND
            stateRxFrame = 5;
            break;
        
        case 5 :
            if(cptDataRxFrame >= strucTrameRx.length - 1){           //On teste si il y a des données à recuperer, on retire 1 pour la COMMAND
                strucTrameRx.data[cptDataRxFrame] = byteRx;         //Reception DATA
                cptDataRxFrame++;
            }
            else
                cptDataRxFrame = 0;             //RAZ du compteur pour le prochain passage
                stateRxFrame = 6;
            break;
        
        case 6 :
            strucTrameRx.csum = byteRx;         //Reception checksum
            
            unsigned char csumCalc = calcCSUM(strucTrameRx.command, strucTrameRx.length, (unsigned char*) strucTrameRx.data);     //Verification csum
            if(csumCalc == strucTrameRx.csum){
                frameRxComplete = true;
                if(infosDebug == true){
                    debugPC.printf("\n\r\tRx : ");
                    debugPC.printf("%02x ", strucTrameRx.header);
                    debugPC.printf("%02x ", strucTrameRx.reserved);
                    debugPC.printf("%02x ", strucTrameRx.length);
                    debugPC.printf("%02x ", strucTrameRx.command);
                    for(unsigned int cpt = 0; cpt < strucTrameRx.length-1; cpt++)
                        debugPC.printf("%02x ", strucTrameRx.data[cpt]);
                    debugPC.printf("%02x ", strucTrameRx.csum);
                }
            }
            stateRxFrame = 0;
            break;
    }
}





unsigned char calcCSUM(unsigned char command, unsigned char lengthData, unsigned char *valData){
    unsigned char csum = 0;    
    
    csum += command;
    csum += lengthData;
    for(unsigned int cpt = 0; cpt<lengthData-1; cpt++)
        csum += *(valData + cpt);
    
    return csum;
}     

/*
unsigned int RxFrame(unsigned char *dataRx){
    unsigned char csum;
    
    //Reception HEADER
    if(comRFID.readable() == 1)
        *(dataRx + 0) = comRFID.getc();
    else 
        return 1;
    if(*(dataRx + 0) != 0xFF)
        return 1;
    debugPC.printf("\n\r\tRx HEADER %02x", *(dataRx + 0));
    
    //Reception RESERVED    
    if(comRFID.readable() == 1)
        *(dataRx + 1) = comRFID.getc();
    else 
        return 1;
    if(*(dataRx + 1) != 0x00)
        return 1;
    debugPC.printf("\n\r\tRx RESERVED %02x", *(dataRx + 1));
    
    //Reception LENGTH    
    if(comRFID.readable() == 1)
        *(dataRx + 2) = comRFID.getc();
    debugPC.printf("\n\r\tRx LENGTH %02x", *(dataRx + 2));
    
    //Reception COMMAND    
    if(comRFID.readable() == 1)
        *(dataRx + 3) = comRFID.getc();
    debugPC.printf("\n\r\tRx COMMAND %02x\n\r\tRx BOUCLE", *(dataRx + 3));
    
    //Reception DATA
    for(unsigned char cpt = 4; cpt<*(dataRx + 2) - 1; cpt++){
        if(comRFID.readable() == 1){
            debugPC.printf(".");
            *(dataRx + cpt) = comRFID.getc();
            debugPC.printf(" (cpt : %02x) %02x .", cpt, *(dataRx + cpt));
        }
        else {
            debugPC.printf("\n\r\tRx BOUCLE OUT");
            return 1;
        }
    }  
    
    //Reception CSUM    
    if(comRFID.readable() == 1)
        *(dataRx + 2 + *(dataRx + 2)) = comRFID.getc();
    debugPC.printf("\n\r\tRx CSUM %02x", *(dataRx + 2 + *(dataRx + 2)));    
    
    
    csum = calcCSUM(*(dataRx+0), *(dataRx+1), (dataRx + 2));
    debugPC.printf("\n\r\tRx VAL CALC CSUM %02x\n\r\t", csum);
    if(csum != *(dataRx + *(dataRx+2) + 3))
        return 1;
         
    //Affiche debug __________________________________________
    debugPC.printf("\n\rRx :\t");
    for(unsigned char cpt = 0; cpt<*(dataRx + 2) + 2; cpt++)
        debugPC.printf("%02x ", *(dataRx+cpt));   
    
    return 0;
}
*/
