#ifndef MAIN_HPP
#define MAIN_HPP

/*****************************************************
------------------------ MAIN ------------------------
*****************************************************/
//Prototypes des fonctions
void flashingLED();
void threadRFID(void const *args);

#define READ_MODE   0x01
#define WRITE_MODE  0x00

/*****************************************************
------------------------ MAIN ------------------------
*****************************************************/

/*****************************************************
------------------------ RFID ------------------------
*****************************************************/
#define HEADER      0xFF
#define RESERVED    0x00

#define ANTENNA_SWITCH_OFF  0x00
#define ANTENNA_SWITCH_ON   0x01



//COMMAND
#define RESET           0x80
#define FIRMWARE        0x81
#define SEEK_FOR_TAG    0x82
#define SELECT_TAG      0x83
#define AUTHENTICATE    0x85
#define READ_BLOCK      0x86
#define WRITE_BLOCK     0x89
#define ANTENNA_POWER   0x90
#define SET_BAUD_RATE   0x94

//STATE
#define SET_RESET           0x00
#define SET_ANTENNA_POWER   0x01
#define READ_TAG            0x02

#define SEEK                0x80
#define AUTHENTI            0x81
#define READ                0x82
#define WRITE               0x83

//Structures
struct DataTrame{
    char header;
    char reserved;
    char length;
    char command;
    char data[25]; 
    char csum;
};

struct InfosTag{
    char tagType;
    char serialNumber[7];
};

struct DonneesTag{
    char typeTrajet;
    char direction;
    char distance;
    char position;
};

//Prototypes des fonctions
void TxFrame(unsigned char command, unsigned char lengthData, unsigned char *data);
unsigned int RxFrame(unsigned char *dataRx);
void RxFrameInterrupt();
unsigned char calcCSUM(unsigned char lengthData, unsigned char command, unsigned char *valData);

/*****************************************************
------------------------ RFID ------------------------
*****************************************************/
#endif