#include "mbed.h"
#include <fonctions_demodulation.h>
#include <fonctions_distance.h>


AnalogIn adc(A0);

int i,j,k;

#define NB_VALEURS 280
#define NB_VALEURS_BIT 36
#define NB_VALEURS_MOYENNE_HAUTE 10

float acquisition[NB_VALEURS];
float acquisition_distance[NB_VALEURS]; 
float seuil;

//Déclarations pour la distance


struct maximum valeur_max[3];
struct minimum valeur_min[3];
struct distance signal;
struct signal_caracteristiques signal_car;
//Valeurs 13 Juin : Mesure 1
//struct distance donnee[]={{562,458,260,0.3999}, {559,430,260,0.49},{524,396,223,0.57},{458,367,160,0.6},{413,345,111,0.6},{380,330,82,0.6},{368,324,73,0.59},{354,318,56,0.62},{341,313,45,0.61}};

//Valeurs 14 Juin : Mesure 2
//struct distance donnee[]={{565,454,275,0.4}, {560,418,270,0.53},{433,349,143,0.58},{389,329,98,0.59},{360,317,72,0.61},{338,307,50,0.61},{324,303,34,0.61},{316,300,26.5,0.61},{313,299,13.5,0.61}};

//Valeurs 14 Juin : Mesure 3 (2 47Ohm en parallèle)
struct distance donnee[]={{563,497,256,0.25}, {563,460,263,0.39},{562,434,257,0.49},{538,402,234,0.58},{464,368,156,0.6},{425,352,118,0.62},{389,336,85,0.625},{375,329,71,0.64},{360,323,57,0.64}};


int indice;
float moyenne;
//Fin déclarations pour la distance


int main() {
    char mot;
    float moyenne;
    mot=0x00;
    while(1){
        //Aquisition pour seuil_moyen
        for(i=0; i< NB_VALEURS; i++){
            acquisition[i]=adc.read();
        }
        seuil = 0;
        for(i=0; i< NB_VALEURS; i++){
            seuil += acquisition[i];
        }
        seuil /= NB_VALEURS;
        
        //Acquisition pour la démodulation
        while(adc.read() > seuil);
        while(adc.read() < seuil);
        for(i=0; i< NB_VALEURS; i++){
            acquisition[i]=adc.read();
        }
            //Reajustement du seuil :
            float max[NB_VALEURS_MOYENNE_HAUTE][2];
                //Moyenne des 1 :
                for(i=0;i<NB_VALEURS_MOYENNE_HAUTE;i++){
                    max[i][0] = 0; //initialisation des indices
                    max[i][1] = acquisition[0]; //initialisation des max
                }
                char already_max=0;
                for(i=0;i<NB_VALEURS_MOYENNE_HAUTE;i++){ //prise de 10 valeurs max
                    for(j=0;j < NB_VALEURS;j++){
                        for(k=0;k<i;k++){
                            if(j == max[k][0]){
                                already_max = 1;
                                break;
                            }
                            else already_max = 0;
                        }
                        if(acquisition[j] > max[i][1] && !already_max){
                             max[i][1] = acquisition[j];
                             max[i][0] = j;
                        }
                    } 
                }
                float moyenne_haute = 0;
                for(i=0;i<NB_VALEURS_MOYENNE_HAUTE;i++){
                    moyenne_haute += max[i][1];
                }
                moyenne_haute /= NB_VALEURS_MOYENNE_HAUTE;
                
                //moyenne des 0;
                
        for (i=0; i<8; i++){
            moyenne = 0;
            for (j=0;j<NB_VALEURS_BIT;j++){
                moyenne += acquisition[i*NB_VALEURS_BIT + j]; 
            }
            moyenne /= NB_VALEURS_BIT;
            mot |= (moyenne > seuil)?0x01:0x00;
            if (i == 7) break;
            mot = mot << 1;
        }

        for (i=0; i<8; i++){
            mot = decale_mot(mot);
            if(mot == 0xAC){
                printf("Mot present\n");
                break;
            }
        }
        
        //----------------------
        //MESURE DISTANCE
        //----------------------
        for(i=0;i<NB_VALEURS;i++){
            acquisition_distance[i] = acquisition[i]*1000;
        }
        for(i=0;i<NB_VALEURS;i++){
            moyenne += acquisition_distance[i];
        }
        moyenne /= NB_VALEURS;
        signal.moyenne=moyenne;
        init_tab_max(valeur_max, acquisition_distance[0]);
        init_tab_min(valeur_min, acquisition_distance[0]);
        have_max(acquisition_distance, valeur_max);
        signal.max = (valeur_max[0].valeur+valeur_max[1].valeur+valeur_max[2].valeur)/3;
        have_min(acquisition_distance, valeur_min);
        signal.min=(valeur_min[0].valeur+valeur_min[1].valeur+valeur_min[2].valeur)/3;
        signal.ecart=signal.max-signal.min;
        signal.rapport=(signal.max-signal.moyenne)/signal.ecart;
        printf("signal.max: %f\n", signal.max);
        printf("signal.min: %f\n", signal.min);
        printf("signal.moyenne: %f\n", signal.moyenne);
        printf("signal.ecart: %f\n", signal.ecart);
        printf("signal.rapport: %f\n", signal.rapport);
        
        init_struct(signal_car);
        verifff(signal, donnee, &signal_car);
        printf_SC(signal_car);
        printf("Distance : %f\n", calcul_distance_V2(signal, signal_car));
        
        
        //----------------------
        //FIN MESURE DISTANCE
        //----------------------
        
        wait(0.5);
    }
}
