#include <fonctions_distance.h>

void init_tab_max(struct maximum tab[3], float acquisition){
    int i;
    for (i=0;i<3;i++){
        tab[i].valeur=acquisition;
        tab[i].indice=0;
    }
}

void init_tab_min(struct minimum tab[3], float acquisition){
    int i;
    for(i=0;i<3;i++){
        tab[i].valeur=acquisition;
        tab[i].indice=0;
    }
}

bool appartient_max(int i, struct maximum tab_max[3]){
    int indice;
    bool state;
    state=false;
    for(indice=0;indice<3;indice++){
        if (tab_max[indice].indice == i) state = true;
    }
    return state;
}


bool appartient_min(int i, struct minimum tab_min[3]){
    int indice;
    bool state;
    state=false;
    for(indice=0;indice<3;indice++){
        if (tab_min[indice].indice == i) state = true;
    }
    return state;
}

void have_max(float tab[NB_VALEURS], struct maximum tab_max[3]){
    int i,j;
    for(j=0;j<3;j++){
        for(i=0;i<NB_VALEURS;i++){
            if (tab_max[j].valeur < tab[i] && appartient_max(i, tab_max) != true){ //La valeur du tableau est supérieure et aucune autre case du tabelau de structure ne contient cette valeur;
                tab_max[j].valeur=tab[i];
                tab_max[j].indice=i;
            }
        }
    }
}

void have_min(float tab[NB_VALEURS], struct minimum tab_min[3]){ // A modifier avec la rejection de valeur;
    int i,j;
    for(j=0;j<3;j++){
        for(i=0;i<NB_VALEURS;i++){
            if (tab_min[j].valeur > tab[i] && appartient_min(i, tab_min) != true){ 
                tab_min[j].valeur=tab[i];
                tab_min[j].indice=i;
            }
        }
    }
}

//ALGO DETECTION DISTANCE
float abs_minus(float a, float b){
    float retour;
    if ((a-b)>=0) retour = a-b;
    else retour = b-a;
    return retour;
}

void init_struct(struct signal_caracteristiques tableau){
    tableau.indice_max=0;
    tableau.indice_moyenne=0;
    tableau.indice_ecart=0;
    tableau.indice_rapport=0;
}

void verifff(struct distance signal, struct distance donnee[], struct signal_caracteristiques *signal_carac){
    int i;
    init_struct(*signal_carac);
    for(i=1;i<9;i++){
        if (abs_minus(signal.max, donnee[signal_carac->indice_max].max) > abs_minus(signal.max, donnee[i].max))signal_carac->indice_max=i;
        if (abs_minus(signal.moyenne, donnee[signal_carac->indice_moyenne].moyenne) > abs_minus(signal.moyenne, donnee[i].moyenne))signal_carac->indice_moyenne=i;
        if (abs_minus(signal.ecart, donnee[signal_carac->indice_ecart].ecart) > abs_minus(signal.ecart, donnee[i].ecart))signal_carac->indice_ecart=i;
        if (abs_minus(signal.rapport, donnee[signal_carac->indice_rapport].rapport) > abs_minus(signal.rapport, donnee[i].rapport))signal_carac->indice_rapport=i;
    }
}

void printf_SC(struct signal_caracteristiques sig){
    printf("indice_max: %d\n", sig.indice_max);
    printf("indice_moyenne: %d\n", sig.indice_moyenne);
    printf("indice_ecart: %d\n", sig.indice_ecart);
    printf("indice_rapport: %d\n", sig.indice_rapport);
}

int calcul_distance_V1(struct distance signal, struct distance donnee[], struct signal_caracteristiques caracteristiques){
    int distance;
    if (caracteristiques.indice_rapport < 3){
        if (abs_minus(signal.rapport, donnee[0].rapport) <= abs_minus(signal.rapport, donnee[1].rapport)) distance = 20;
        else {
            if (abs_minus(signal.rapport, donnee[1].rapport) < abs_minus(signal.rapport, donnee[2].rapport)) distance = 30;
            else distance = 40;
        }
    }
    else{
        if (abs_minus(signal.ecart, donnee[3].ecart) < abs_minus(signal.ecart, donnee[4].ecart)) distance = 50;
        else {
            if (signal.ecart < donnee[8].ecart) distance = 100;
            else if (signal.ecart < donnee[7].ecart) distance = 90;
            else if (signal.ecart < donnee[6].ecart) distance = 80;
            else if (signal.ecart < donnee[5].ecart) distance = 70;
            else distance = 60;
        }
    }
    return distance;
}

float convert_indice(int indice){
    return indice*10+20;
}

float calcul_distance_V2(struct distance signal, struct signal_caracteristiques caracteristiques){
    float distance;
    if(convert_indice(caracteristiques.indice_rapport) <= 40)
        distance = convert_indice(caracteristiques.indice_rapport);
    else if(convert_indice(caracteristiques.indice_ecart) == 100)
        distance = 100;
    else
        distance = 0.5*convert_indice(caracteristiques.indice_rapport) + 0.5*convert_indice(caracteristiques.indice_ecart);
    return distance;

}
//FIN ALGO DETECTION DISTANCE