#include "mbed.h"
#define NB_VALEURS 280
#define NB_VALEURS_BIT 36
#define NB_VALEURS_MOYENNE_HAUTE 10


struct distance{
    float max;
    float min;
    float moyenne;
    float ecart;
    float rapport;
};

struct maximum{
    float valeur;
    int indice;
};

struct minimum{
    float valeur;
    int indice;
};

struct signal_caracteristiques{
    int indice_max;
    int indice_moyenne;
    int indice_ecart;
    int indice_rapport;
};


//Fonctions pour les paramètres distance
void init_tab_max(struct maximum tab[3], float acquisition);

void init_tab_min(struct minimum tab[3], float acquisition);

bool appartient_max(int i, struct maximum tab_max[3]);

bool appartient_min(int i, struct minimum tab_min[3]);

void have_max(float tab[NB_VALEURS], struct maximum tab_max[3]);

void have_min(float tab[NB_VALEURS], struct minimum tab_min[3]);

//Fonctions de calcul de la distance
float abs_minus(float a, float b);

void init_struct(struct signal_caracteristiques tableau);

void verifff(struct distance signal, struct distance donnee[], struct signal_caracteristiques *signal_carac);

void printf_SC(struct signal_caracteristiques sig);

int calcul_distance_V1(struct distance signal, struct distance donnee[], struct signal_caracteristiques caracteristiques);

float convert_indice(int indice);

float calcul_distance_V2(struct distance signal, struct signal_caracteristiques caracteristiques);