#include "mbed.h"

AnalogIn adc(A0);

DigitalOut gpio(D8);

float tab[330];
int i,j;

#define delay_bit 119
#define DELAY_ZERO 10
#define SEUIL_MOYEN 0.60

bool wait_zero(void){
    int valeur;
    valeur=0;
    while (adc.read() < SEUIL_MOYEN){
        valeur++;
        wait_us(5);
    }
    return (valeur < SEUIL_MOYEN)?true:false;
}

char decale_mot(char mot){ //Cette fonction effectue un décalage du mot de 1 cran vers la gauche
    mot=((mot&0x7F)<<1)|((mot&0x80)>>7); 
    return mot;
}  

int main() {
    gpio=0;
    wait_ms(500);
    char mot;
    float moyenne;
    mot=0x00;
    printf("Debut\n");
    while(adc.read() > SEUIL_MOYEN);
    while(adc.read() < SEUIL_MOYEN);
    gpio=1;
    for(i=0; i< 330; i++){
        tab[i]=adc.read();
    }
    for (i=0; i<8; i++){
        moyenne = 0;
        for (j=0;j<36;j++){
            moyenne += tab[i*36 + j]; 
        }
        moyenne /= 36.0;
        mot |= (moyenne > SEUIL_MOYEN)?0x01:0x00;
        if (i == 7) break;
        mot = mot << 1;
    }
    gpio=0;
    for (i=0; i<8; i++){
        mot = decale_mot(mot);
        printf("%x\n", mot);
    }
}
