
#include "mbed.h"
#include "max7219.h"

// ***************************************************************************
// option 1 : use  SPI
// ***************************************************************************
/*SPI deviceM(PA_7, PA_6, PA_5);
DigitalOut ssel (PB_12);

#define  uint8_t unsigned char
uint8_t vcol2[8]={0,0,0,0,0,0,0,0};

 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};


void printMatrix(uint8_t*  vC)

{
    uint8_t i =0;
    for (i=1;i<9;i++){
        sendSPI(i,*(vC+i));
    }
        
    };

void clr_vcol()
    {
    for (int i=0; i<8;i++){
            vcol2[i]=0;
    }
    
}   
 
void print_Snake2()
{
    
    int j, i;
      //reset
    
    for (j=0; j<8;j++){
        clr_vcol();
        if(j % 2 == 0)
            vcol2[j]=1;
        else
            vcol2[j]=0b10000000;
    
        for (i=0; i<8;i++){
            if(j % 2 == 0){
                 vcol2[j]=3<<i;
                }
            else{
                 vcol2[j]=0b1100000000>>i;
                }
            printMatrix(vcol2);
            wait_ms(5);
            }
        }
}

void print_Snake()
{
       
    uint8_t vt1[8]={1,3,7,0xf,0x1f,0x3f, 0x7f,0xff};
    uint8_t vt2[8]={0b10000000,0b11000000,0b11100000,0b11110000,0b11111000,0b11111100,0b11111110,0b11111111};
    
      
    int j, i;
      //reset
    clr_vcol();
    for (j=0; j<8;j++){
        for (i=0; i<8;i++){
            if(j % 2 == 0){
                vcol2[j]=vt1[i];
            }else{
                vcol2[j]=vt2[i];
            }
            printMatrix(vcol2);
            wait_ms(5);
        }
        }    
}   
int main() {
                    uint8_t vcol[8]={0,0,0,0,0,0,0,0};
                    sendSPI(0x0c,1);
                    sendSPI(0x0F,1);
                    wait (0.1);
                    sendSPI(0x0f,0);
                    wait (0.1);
                    int i =0;
                    while(1){
                        print_Snake();
                        }
}*/
// ***************************************************************************
// option two: use max7219 library

// ***************************************************************************    


 Max7219 max7219(PA_7, PA_6, PA_5, D2);

 int main()
 {
     max7219_configuration_t cfg = {
         .device_number = 1,
         .decode_mode = 3,
         .intensity = Max7219::MAX7219_INTENSITY_5,
         .scan_limit = Max7219::MAX7219_SCAN_8
     };

     max7219.init_device(cfg);
     max7219.enable_device(1);
     max7219.set_display_test();
     wait(1);
     max7219.clear_display_test();






     
    while(1){
         
         max7219.write_digit(1,1,0b01010101);
         max7219.write_digit(1,2,0b10101010);
         max7219.write_digit(1,3,0b01010101);
         max7219.write_digit(1,4,0b10101010);
         max7219.write_digit(1,5,0b01010101);
         max7219.write_digit(1,6,0b10101010);
         max7219.write_digit(1,7,0b01010101);
         max7219.write_digit(1,8,0b11001100);
         
         
         max7219.write_digit(2,1,0b01010101);
         max7219.write_digit(2,2,0b10101010);
         max7219.write_digit(2,3,0b01010101);
         max7219.write_digit(2,4,0b10101010);
         max7219.write_digit(2,5,0b01010101);
         max7219.write_digit(2,6,0b10101010);
         max7219.write_digit(2,7,0b01010101);
         max7219.write_digit(2,8,0b11001100);
         
         
         max7219.write_digit(3,1,0b01010101);
         max7219.write_digit(3,2,0b10101010);
         max7219.write_digit(3,3,0b01010101);
         max7219.write_digit(3,4,0b10001010);
         max7219.write_digit(3,5,0b01010101);
         max7219.write_digit(3,6,0b10101010);
         max7219.write_digit(3,7,0b01010101);
         max7219.write_digit(3,8,0b11001100);
         
         
         max7219.write_digit(4,1,0b01010101);
         max7219.write_digit(4,2,0b10101010);
         max7219.write_digit(4,3,0b01010101);
         max7219.write_digit(4,4,0b10101010);
         max7219.write_digit(4,5,0b01011101);
         max7219.write_digit(4,6,0b10101010);
         max7219.write_digit(4,7,0b01010101);
         max7219.write_digit(4,8,0b11001100);
         ;
        
        }
}


