#include "mbed.h"
#include <string>
#include <stdio.h>      /* printf, scanf, puts, NULL */
#include <stdlib.h>     /* srand, rand */
#include <time.h>       /* time */
using std::string;
// p5: DIN, p7: CLK, p8: LOAD/CS
SPI max72_spi(PA_7, PA_6, PA_5);
DigitalOut load(D2);
Serial pc(SERIAL_TX, SERIAL_RX);
InterruptIn mybutton(USER_BUTTON);
int maxInUse = 4;    //Anzahl der Benutzen MAX7219 

// define max7219 registers
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define LOW 0
#define HIGH 1
#define MHZ 1000000

void maxSingle( int reg, int col) {
//maxSingle is the "easy"  function to use for a
//single max7219
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}

void maxAll (int reg, int col) {    // initialize  all  MAX7219's in the system
    load = LOW;                    // begin
    for ( int c=1; c<= maxInUse; c++) {
        max72_spi.write(reg);  // specify register
        max72_spi.write(col);  // put data
    }
    load = HIGH;
}

void maxOne(int maxNr, int reg, int col) {
//maxOne is for adressing different MAX7219's,
//while having a couple of them cascaded
    int c = 0;
    load = LOW;

    for ( c = maxInUse; c > maxNr; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }

    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data

    for ( c=maxNr-1; c >= 1; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
    load = HIGH;
}



void setup () {
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
    
    // going by the datasheet, min clk is 100ns so theoretically 10MHz should work...
    max72_spi.frequency(10*MHZ);
    
    maxAll(max7219_reg_scanLimit, 0x07);
    maxAll(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    maxAll(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        maxAll(e,0);
    }
    maxAll(max7219_reg_intensity, 0x01 & 0x0f);    // the first 0x0f is the value you can set
    // range: 0x00 to 0x0f
}



int getBitValue(int bit)
{
    pc.printf("bit = %d\n\r", bit);
    switch(bit)
    {
        case 0: return 1;
        case 1: return 2;
        case 2: return 4;
        case 3: return 8;
        case 4: return 16;
        case 5: return 32;
        case 6: return 64;
        case 7: return 128;
    }
    return 0;
}
void interpret(string data, int maxId, int rowId)
{
    int value = 0;
    for(int c=0;c<8;c++)
    {
        if(data.substr(c,1) == "+")
        {
             value += getBitValue(c);
              pc.printf("value = %d\n\r",value);
        }
    }
    pc.printf("value = %d\n\r",value);
    maxOne(maxId, rowId ,value);
}

int _GameMode1 = 1;
int _GameMode2 = 2;
int _GameMode3 = 3;
int _GameMode4 = 4;
int _Step1 = 0;
int _MaxStep1 = 1;
int _Step2 = 0;
int _MaxStep2 = 1;
int _Step3 = 0;
int _MaxStep3 = 1;
int _Step4 = 0;
int _MaxStep4 = 1;
int _Step5 = 0;
int _MaxStep5 = 1;
int _LastGameMode1 = 0;
int _LastGameMode2 = 0;
int _LastGameMode3 = 0;
int _LastGameMode4 = 0;

void Mode1(int index)
{
    switch(index)
    {
        case 1:
            if(_LastGameMode1 != 1)
            {
                _Step1 = 0;
                _MaxStep1 = 9;
                _LastGameMode1 = _GameMode1;
            }
            break;
        case 2:
            if(_LastGameMode2 != 1)
            {
                _Step1 = 0;
                _MaxStep1 = 9;
                _LastGameMode2 = _GameMode2;
            }
            break;
        case 3:
            if(_LastGameMode3 != 1)
            {
                _Step1 = 0;
                _MaxStep1 = 9;
                _LastGameMode3 = _GameMode3;
            }
            break;
        case 4:
            if(_LastGameMode4 != 1)
            {
                _Step1 = 0;
                _MaxStep1 = 9;
                _LastGameMode4 = _GameMode4;
            }
            break;
    }
    switch(_Step1)
    {
        while (_Step1 ==1) {
        case 0:
            interpret("--------",index,1);
            interpret("----+---",index,2);
            interpret("----+---",index,3);
            interpret("----+---",index,4);
            interpret("----+---",index,5);
            interpret("----+---",index,6);
            interpret("--------",index,7);
            interpret("--------",index,8);
            break;
        case 1:
            interpret("--------",index,1);
            interpret("--------",index,2);
            interpret("--------",index,3);
            interpret("--------",index,4);
            interpret("--------",index,5);
            interpret("--------",index,6);
            interpret("--------",index,7);
            interpret("--------",index,8);
            break;
                     
        }
    }
    wait_ms(20);
}
void Mode2(int index)
{
    switch(index)
    {
        case 1:
            if(_LastGameMode1 != 2)
            {
                _Step2 = 0;
                _MaxStep2 = 9;
                _LastGameMode1 = _GameMode1;
            }
            break;
        case 2:
            if(_LastGameMode2 != 2)
            {
                _Step2 = 0;
                _MaxStep2 = 9;
                _LastGameMode2 = _GameMode2;
            }
            break;
        case 3:
            if(_LastGameMode3 != 2)
            {
                _Step2 = 0;
                _MaxStep2 = 9;
                _LastGameMode3 = _GameMode3;
            }
            break;
        case 4:
            if(_LastGameMode4 != 2)
            {
                _Step2 = 0;
                _MaxStep2 = 9;
                _LastGameMode4 = _GameMode4;
            }
            break;
    }
    
     switch(_Step2)
    {
        case 0:
            interpret("--------",index,1);
            interpret("-++++++-",index,2);
            interpret("-+-----",index,3);
            interpret("-++++++-",index,4);
            interpret("------+-",index,5);
            interpret("-++++++-",index,6);
            interpret("--------",index,7);
            interpret("--------",index,8);
            break;
        case 1:
            interpret("--------",index,1);
            interpret("--------",index,2);
            interpret("--------",index,3);
            interpret("--------",index,4);
            interpret("--------",index,5);
            interpret("--------",index,6);
            interpret("--------",index,7);
            interpret("--------",index,8);
            break;            
        
    }
    wait_ms(5);
}
void Mode3(int index)
{
    switch(index)
    {
        case 1:
            if(_LastGameMode1 != 3)
            {
                _Step3 = 0;
                _MaxStep3 = 9;
                _LastGameMode1 = _GameMode1;
            }
            break;
        case 2:
            if(_LastGameMode2 != 3)
            {
                _Step3 = 0;
                _MaxStep3 = 9;
                _LastGameMode2 = _GameMode2;
            }
            break;
        case 3:
            if(_LastGameMode3 != 3)
            {
                _Step3 = 0;
                _MaxStep3 = 9;
                _LastGameMode3 = _GameMode3;
            }
            break;
        case 4:
            if(_LastGameMode4 != 3)
            {
                _Step3 = 0;
                _MaxStep3 = 9;
                _LastGameMode4 = _GameMode4;
            }
            break;
    }
    
     switch(_Step3)
    {
        case 0:
            interpret("--------",index,1);
            interpret("-++++++-",index,2);
            interpret("------+-",index,3);
            interpret("-++++++-",index,4);
            interpret("------+-",index,5);
            interpret("-++++++-",index,6);
            interpret("--------",index,7);
            interpret("--------",index,8);
            break;
        case 1:
            interpret("--------",index,1);
            interpret("--------",index,2);
            interpret("--------",index,3);
            interpret("--------",index,4);
            interpret("--------",index,5);
            interpret("--------",index,6);
            interpret("--------",index,7);
            interpret("--------",index,8);
            break;            
        
    }
    wait_ms(5);
}
void Mode4(int index)
{
    switch(index)
    {
        case 1:
            if(_LastGameMode1 != 4)
            {
                _Step4 = 0;
                _MaxStep4 = 9;
                _LastGameMode1 = _GameMode1;
            }
            break;
        case 2:
            if(_LastGameMode2 != 4)
            {
                _Step4 = 0;
                _MaxStep4 = 9;
                _LastGameMode2 = _GameMode2;
            }
            break;
        case 3:
            if(_LastGameMode3 != 4)
            {
                _Step4 = 0;
                _MaxStep4 = 9;
                _LastGameMode3 = _GameMode3;
            }
            break;
        case 4:
            if(_LastGameMode4 != 4)
            {
                _Step4 = 0;
                _MaxStep4 = 9;
                _LastGameMode4 = _GameMode4;
            }
            break;
    }
    switch(_Step4)
    {
        case 0:
            interpret("--------",index,1);
            interpret("------+-",index,2);
            interpret("------+-",index,3);
            interpret("-++++++-",index,4);
            interpret("-+----+-",index,5);
            interpret("-+----+-",index,6);
            interpret("--------",index,7);
            interpret("--------",index,8);
            
            break;
        
        case 1:
            interpret("--------",index,1);
            interpret("--------",index,2);
            interpret("--------",index,3);
            interpret("--------",index,4);
            interpret("--------",index,5);
            interpret("--------",index,6);
            interpret("--------",index,7);
            interpret("--------",index,8);
            break;            
      
    }
    wait_ms(5);
}


int MAX_MODE = 4;
void pressed()
{
    _GameMode1++;
    if(_GameMode1 > MAX_MODE) _GameMode1 = 1;
    _GameMode2++;
    if(_GameMode2 > MAX_MODE) _GameMode2 = 1;
    _GameMode3++;
    if(_GameMode3 > MAX_MODE) _GameMode3 = 1;
    _GameMode4++;
    if(_GameMode4 > MAX_MODE) _GameMode4 = 1;
}

void DisplayGameMode()
{
    switch(_GameMode1)
    {
        case 1: Mode1(1); break;
        case 2: Mode2(1); break;
        case 3: Mode3(1); break;
        case 4: Mode4(1); break;
    }
    switch(_GameMode2)
    {
        case 1: Mode1(2); break;
        case 2: Mode2(2); break;
        case 3: Mode3(2); break;
        case 4: Mode4(2); break;
    }
    switch(_GameMode3)
    {
        case 1: Mode1(3); break;
        case 2: Mode2(3); break;
        case 3: Mode3(3); break;
        case 4: Mode4(3); break;
    }
    switch(_GameMode4)
    {
        case 1: Mode1(4); break;
        case 2: Mode2(4); break;
        case 3: Mode3(4); break;
        case 4: Mode4(4); break;
    }
    _Step1++;
    if(_Step1 > _MaxStep1)_Step1 = 0;
    _Step2++;
    if(_Step2 > _MaxStep2)_Step2 = 0;
    _Step3++;
    if(_Step3 > _MaxStep3)_Step3 = 0;
    _Step4++;
    if(_Step4 > _MaxStep4)_Step4 = 0;
    

}
int main() {
    mybutton.fall(&pressed);
    srand (time(NULL));
    setup ();
    while(true){DisplayGameMode();}
}