#include "mbed.h"
#include "WS2812B.h"
#include "TextLCD.h"
#include <string>

I2C i2c(P0_5,P0_4);
Serial port(P0_19,P0_18);
BusOut myled(P1_8,P1_9,P1_10,P1_11,P1_0,P1_1,P1_3,P1_4,P1_6,P1_7,P1_12,P1_13);
AnalogIn ldr(P0_12);
AnalogIn poti(P0_11);
//BusOut rgb(P0_9,P1_15,P0_21);
//BusIn btn(P1_16,P0_23,P0_10,P0_15);

RGBOut rgb(P0_21,P0_9,P1_15);
TextLCD lcd(p21, p22, p26, p25, p24, p23,TextLCD::LCD20x4);

LedOut Feld (P0_13);
//LedOut Other(P0_13); //-> Würfel (ersten 3 LED in Binär-4. LED für 7. Zustand), Spieler, Start, Ziel, Referenz(auch RGB am board)
// übrige 8 LED für zeit-Anzeige des Zuges einer KI

InterruptIn Button0(P0_1);
InterruptIn Button1(P1_16);
InterruptIn Button2(P0_23);
InterruptIn Button3(P0_10);
InterruptIn Button4(P0_15);

InterruptIn DD_A(P0_22);//20
InterruptIn DD_B(P0_16);//19
InterruptIn DD_C(P0_14);//18
DigitalIn DD_D(P0_14);
BusIn DD(P0_22,P0_16);
//Timeout DD_reset;
char DD_last;
char DD_d;

void dreh();
void druck();

void up();
void down();
void accept();
void exit();
void print_menu();
void Control();
void ausfuehren();

//string test ("");
//                                "1234567890123456789","1234567890123456789","1234567890123456789","1234567890123456789",  ,"1234567890123456789","1234567890123456789","1234567890123456789",
const char * const  text_ln0[] = {"MENU:              ","Spiel-Menu:        ","Anzeige-Menu:      ","Speicher-Menu:     ","","7.Zustand-Menu:    ","Farben-Menu:       ","Spiel-Menu:        ","","Spielregeln-Menu:  ","Hell./Sp.Led-Menu: ","Config-Menu:       ","","Autplay-Menu:      ","Wurfel-Menu:       ","Ofline/Com-Menu:   ","","Colour-Menu        "};
const char * const  text_ln1[] = {"Spiel              ","7.Zustand          ","Farben             ","Spiel              ","","Disable            ","accept             ","Laden              ","","Schmeiszwang <I/0> ","Wert: <wert>       ","Laden              ","","Zeit               ","Farbverhalten      ","New                ","","RED"};
const char * const  text_ln2[] = {"Anzeige            ","Spielregeln        ","Hellichkeit/Sp.Led ","Config.            ","","Enable             ","SP: 1   2   3   4  ","Speichern          ","","Go Home first <I/0>","Sp.Led-Verhalten   ","Speichern          ","","Agro/Taktik        ","Farb def           ","Reset              ","","BLU"};
const char * const  text_ln3[] = {"Speicher           ","Autoplay           ","Wurfel             ","Ofline/Com         ","","                   ","                   ","Reset              ","","Ausfahrzwang <I/0> ","Andert: <wert>     ","Reset              ","","Enable/Manuell     ","Hellichkeit        ","Com                ","","GRE"};
// xx/xx/xx/xx/Xx
//  4  3  2  1  0       //ebenen

char selected[256];//Auf welchem Punkt er im Menü ist bzw zuletzt war
char depth = 0;//WEnn man nicht im Menü ist ist es n0; bei 1 in menu bei 2 in untermenu
int postion = 0;//Dafür brauche ich die Methode


int main() 
{
    //Random.start();
    //Random.stop();
    //Random.read_us();
    
    //Ticker:
    //.attach(&main,[sek]);
    //.attach_us(&main,[micro-sec]);
    //.detach();
    
    //myled = 0xFFF;
    port.baud(76800);       //zu übertragung für den PC
    port.format(8,Serial::None, 1); 
    port.attach(&Control);
    /*
    __disable_irq();
    __enable_irq();
    */
    wait(0.01);
    DD_A.mode(PullDown);//Schaltet indern einen Pulldown WIeder ein
    DD_B.mode(PullDown);
    DD_C.mode(PullDown);
    DD_A.rise(&dreh);//Interrupt rudine zuweisen
    DD_A.fall(&dreh);
    DD_B.rise(&dreh);
    DD_B.fall(&dreh);
    DD_C.rise(&druck);
    DD_C.fall(&druck);
    DD_last = DD;//fürs entprellen
    DD_d=DD_D;
    
    //text_ln0[0]="";
    //port.printf("D%c%ctest\n",27,27);
    print_menu();
    
    while(1) ;        
}
void Control()
{
    while(port.readable ())
    {
        char message = port.getc();
        switch(message)
        {
            case 'D':
                port.printf("Ldepth:%d,selected[depth-1]:%d\n",depth,selected[depth-1]);
            break;
            case 'E':
                exit();
            break;
            case 'F':
                up();
            break;
            case 'G':
                down();
            break;
            case 'H':
                accept();
            break;
            case 'I':
                depth=0;
                selected[0]=0;
                print_menu();
            break;
        }
    }
}
void dreh()
{
    char temp = DD;
    if(DD_last == 3)
    { 
        if(temp == 0)
            DD_last = 0;
    }
    else
    {
        if(temp == 3)
        {
            if(DD_last == 1)
                up();
            if(DD_last == 2)
                down();
        }
        DD_last = temp;
    }
}

void druck()
{
    if(DD_D==DD_d)
        return;
    else  if(DD_D)
        accept();
    DD_d=DD_D;
}

void up()
{
    if(depth>0)
    {
        if(selected[depth-1]<1)
            selected[depth-1]=3;
        else
            selected[depth-1]--;
        print_menu();
    }
}
void down()
{
    if(depth>0)
    {
        if(selected[depth-1]>2)
            selected[depth-1]=0;
        else
            selected[depth-1]++;
        print_menu();
    }
}
void accept()
{
    if(depth>0)
    {
        
            if(depth<=3)
            {
                if(selected[depth-1]==0)
                    exit();
                else
                {
                    selected[depth]=1;
                    depth++;
                }
            }
    }
    else
        depth=1;
    print_menu();
}
bool ausfuehren()
{

}
void exit()
{
    if(depth>0)
    {
        depth--;
        if(depth<=3)
            selected[depth]=0;
    }
    print_menu();
}
void print_menu()
{
    if(depth>0)
    {
        if(depth>3)//        "                    "
        {
            port.printf("D%c%c Custom              \n",27,27);
            lcd.locate(0,0);
            lcd.printf(" Custom              ");
        }
        else
        {
            uint32_t _selected = 0;
            for(char i = 0;i<depth-1;i++)
                _selected = _selected|(selected[i]<<(i*2));
            //port.printf("L_selected:%d\n",_selected);
            lcd.locate(1,0);
            lcd.printf(text_ln0[_selected]);
            port.printf("D%c%c%s\n",28,27,text_ln0[_selected]);
            lcd.locate(1,1);
            lcd.printf(text_ln1[_selected]);
            port.printf("D%c%c%s\n",28,28,text_ln1[_selected]);
            lcd.locate(1,2);
            lcd.printf(text_ln2[_selected]);
            port.printf("D%c%c%s\n",28,29,text_ln2[_selected]);
            lcd.locate(1,3);
            lcd.printf(text_ln3[_selected]);
            port.printf("D%c%c%s\n",28,30,text_ln3[_selected]);
            
            for(char i=0;i<4;i++)
            {
                lcd.locate(0,i);
                if(selected[depth-1]==i)
                {
                    if(i==0)
                    {
                        port.printf("D%c%c<\n",27,i+27);
                        lcd.putc('<');
                    }
                    else
                    {
                        port.printf("D%c%c>\n",27,i+27);
                        lcd.putc('>');
                    }
                }
                else
                {
                    port.printf("D%c%c \n",27,i+27);
                    lcd.putc(' ');
                }
            }
        }
    }
    else
    {
        lcd.cls();
        lcd.printf(" Spiel lauft...");
        lcd.locate(0,3);
        lcd.printf("12345678901234567890");
        port.printf("D%c%c Spiel lauft...     \n",27,27);
        port.printf("D%c%c                    \n",27,28);
        port.printf("D%c%c                    \n",27,29);
        port.printf("D%c%c12345678901234567890\n",27,30);
    }
}

