#include "mbed.h"
#include "Serial_HL.h"
#include "FuncGenFSST3.h"
 
SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

void CommandHandler();

SingnedRampGen fg1;
float ampl=1.0,  v1=0.0;

void ExecSignalChain();

int main(void)
{
    pc.format(8,SerialBLK::None,1); pc.baud(500000); // 115200
    
    
    ua0.SvMessage("FuncGenMain2"); // Meldung zum PC senden
  
  Timer stw; stw.start();
  while(1) //  while(1)-Loop der mit dem PC kommuniziert
  {
    CommandHandler();
    if( (stw.read_ms()>10) ) // 100Hz
    { // dieser Teil wird mit 100Hz aufgerufen
        ExecSignalChain();
      stw.reset();
      if( ua0.acqON ) {
        ua0.WriteSV(1, v1);
      }
    }
  }
  return 1;
}

void ExecSignalChain()
{
  fg1.CalcOneStep();
  v1 = fg1.val*ampl;
}

void CommandHandler()
{
  uint8_t cmd;
  if( !pc.IsDataAvail() )
    return;
  cmd = ua0.GetCommand();

  if( cmd==2 ) { // set Frequ
    fg1.SetFrequ(ua0.ReadF());
    ua0.SvMessage("SetFrequ"); 
  }

  if( cmd==3 ) { // set Ampl
    ampl = ua0.ReadF();
    ua0.SvMessage("Set Ampl"); 
  }
}


