#include "mbed.h"
#include "WS2812B.h"
#include "TextLCD.h"

I2C i2c(P0_5,P0_4);
Serial port(P0_19,P0_18);
BusOut myled(P1_8,P1_9,P1_10,P1_11,P1_0,P1_1,P1_3,P1_4,P1_6,P1_7,P1_12,P1_13);
AnalogIn ldr(P0_12);
AnalogIn poti(P0_11);
//BusOut rgb(P0_9,P1_15,P0_21);

RGBOut rgb(P0_21,P0_9,P1_15);
                    //Old: P0_13
LedOut Feld (P1_23);//P1_23 ->14
LedOut Home (P1_20);//P1_20->13
LedOut Dice (P1_21);//P1_21->12
//-> Würfel (ersten 3 LED in Binär-4. LED für 7. Zustand), Spieler, Referenz(auch RGB am board)

InterruptIn Button0(P0_1);
InterruptIn Button1(P1_16);
InterruptIn Button2(P0_23);
InterruptIn Button3(P0_10);
InterruptIn Button4(P0_15);
BusIn btn(P1_16,P0_23,P0_10,P0_15,P0_1);
//Dice
Timer Random;
Timer RandomDice;

Ticker DiceAnim;
void DiceRun();
void setDice(char number);
void DicePrint();
void DiceCal(); //umrechning des 7.Zustands in eine Zahl zwischen 1 & 6
char dicePos = 0;
char diceEn = 0;
char diceTick = 0;
char diceNum = 0;
int16_t diceDecode [7]= {0x1,0x88,0x89,0xAA,0xAB,0x1BA,0x154};
//Game
#define Feldgrose 10
#define Spieler 4
#define Steine 4

char PlayPos[Spieler*Steine];   //Zahl zwischen 0 & 47 ((0xC0 -> Spieler)>>2 / 0x03 -> Stein)
char Start[Spieler*Steine];           //Enthält den Index für PlayPos (nur das 'normale' Spielfend)
char Ziel[Spieler*Steine];            //Enthält den Index für PlayPos (nur das 'normale' Spielfend)
char Drann;                    //Spieler, der drann ist
char count;                    //Für 6er & mehrfaches Würfeln beim Ansetzen
char last[Spieler];            //zuletzt benutzte Spielstein, der zuletzt benutzt wurde
char moglich[Steine];
char selected;                 //der aktuell ausgewählte Zug
char Field[Spieler*Feldgrose]; //Enthält den Index für PlayPos (nur das 'normale' Spielfend)
void FieldPrint();             //Ausgabe auf Com-Port
void FieldGenerate();          //Berechnung von PlayPos auf Start, Ziel, Field
void FeldPrint();              //Ausgabe von Field auf den Led-Streifen (Feld) der Farben
void GameCal();
Ticker MoveAnim;
void MoveRun();
char MoveShow;
void ColorPrint(uint32_t color);
//Animations
char AnimField[Spieler*Feldgrose];
char AnimStart[Spieler*Steine];           
char AnimZiel[Spieler*Steine];
char AnimPos[Spieler*Steine];
char AnimDo; //Feld_Animieren,Start Animieren, Ziel Animierenw
void AnimCal();
//Core Interactions
void reset();
void MoveDo();
void moveNext();
void moveLast();
void DiceStart();
void DiceStop();
//Button entprellung (funktioniert nicht...)
void btn0();
void btn1();
void btn2();
void btn3();
void btn4();
char btnLast;
//Farben
uint32_t Farben[Spieler];      //Berechnete Hellichkeiten der Speiler fertig zur Ausgabe...
uint32_t Background = 0;       //Hintergrund (Leerfeld)
uint32_t DiseC = 0x00FF00;     //Würfelfarbe
void ColorPrint(uint32_t color); //vorher den Header senden (manuell...)


TextLCD lcd(p21, p22, p26, p25, p24, p23,TextLCD::LCD20x4);

InterruptIn DD_A(P0_22);//20
InterruptIn DD_B(P0_16);//19
InterruptIn DD_C(P0_14);//18
DigitalIn DD_D(P0_14);
BusIn DD(P0_22,P0_16);
//Timeout DD_reset;
char DD_last;
char DD_d;

void dreh();
void druck();

void up();
void down();
void accept();
void exit();
void print_menu();
void print_pos();
void print_default();
void posUpdate();
void Control();
char ausfuehren();

//string test ("");
//                                "1234567890123456789","1234567890123456789","1234567890123456789","1234567890123456789",  ,"1234567890123456789","1234567890123456789","1234567890123456789",
const char * const  text_ln0[] = {"MENU:              ","Spiel-Menu:        ","Anzeige-Menu:      ","Speicher-Menu:     ","","7.Zustand-Menu:    ","Farben-Menu:       ","Spiel-Menu:        ","","Spielregeln-Menu:  ","Hell./Sp.Led-Menu: ","Config-Menu:       ","","Autplay-Menu:      ","Wurfel-Menu:       ","Ofline/Com-Menu:   "};
const char * const  text_ln1[] = {"Spiel              ","7.Zustand          ","Farben             ","Spiel              ","","Disable            ","Hoffentlich        ","Laden              ","","Smeiszwang <I/0>   ","Wert: <wert>       ","Laden              ","","Zeit               ","Farbverhalten      ","New                "};
const char * const  text_ln2[] = {"Anzeige            ","Spielregeln        ","Hellichkeit/Sp.Led ","Config.            ","","kleinstmoglich     ","   1   2   3   4   ","Speichern          ","","Go Home first <I/0>","Sp.Led-Verhalten   ","Speichern          ","","Agro/Taktik        ","Farb def           ","Reset              "};
const char * const  text_ln3[] = {"Speicher           ","Autoplay           ","Wurfel             ","Ofline/Com         ","","grostmoglich       ","                   ","Reset              ","","Ausfahrzwang <I/0> ","Andert: <wert>     ","Reset              ","","Enable/Manuell     ","Hellichkeit        ","Com                "};
char textPos[]                 = {0x0                  ,0x1                  ,0x2                  ,0x3                  ,0x4,0x5                 ,0x6                  ,0x7                  ,0x8,0x9                 ,0xA                  ,0xB                  ,0xC,0xD                 ,0xE                  ,0xF                  ,0x10,0x11};


char VHS = 0;
char mSelected[256];
char depth = 0;
uint32_t postion = 0;//Dafür brauche ich die Methode


int main() 
{
    //Random.start();
    //Random.stop();
    //Random.read_us();
    
    //Ticker:
    //.attach(&main,[sek]);
    //.attach_us(&main,[micro-sec]);
    //.detach();
    
    //myled = 0xFFF;
    port.baud(76800);
    port.format(8,Serial::None, 1); 
    port.attach(&Control);
    /*
    __disable_irq();
    __enable_irq();
    */
    
    DD_A.mode(PullDown);
    DD_B.mode(PullDown);
    DD_C.mode(PullDown);
    wait(0.01);
    DD_A.rise(&dreh);
    DD_A.fall(&dreh);
    DD_B.rise(&dreh);
    DD_B.fall(&dreh);
    DD_C.rise(&druck);
    DD_C.fall(&druck);
    DD_last = DD;
    DD_d=DD_D;
    
    //text_ln0[0]="";
    //port.printf("D%c%ctest\n",27,27);
    print_default();
    
    while(1) ;        
}
void print_default()
{
    lcd.cls();
    lcd.printf(" Spiel lauft...");
    lcd.locate(0,3);
    lcd.printf("12345678901234567890");
    port.printf("D%c%c Spiel lauft...     \n",27,27);
    port.printf("D%c%c                    \n",27,28);
    port.printf("D%c%c                    \n",27,29);
    port.printf("D%c%c12345678901234567890\n",27,30);
}
void Control()
{
    while(port.readable ())
    {
        char message = port.getc();
        switch(message)
        {
            case 'D':
                port.printf("Ldepth:%d,mSelected[depth-1]:%d\n",depth,mSelected[depth-1]);
            break;
            case 'E':
                exit();
            break;
            case 'F':
                up();
            break;
            case 'G':
                down();
            break;
            case 'H':
                accept();
            break;
            case 'I':
                depth=0;
                mSelected[0]=0;
                print_menu();
            break;
        }
    }
}
void dreh()
{
    char temp = DD;
    if(DD_last == 3)
    { 
        if(temp == 0)
            DD_last = 0;
    }
    else
    {
        if(temp == 3)
        {
            if(DD_last == 1)
                up();
            if(DD_last == 2)
                down();
        }
        DD_last = temp;
    }
}
char ausfuehren()
{
    char out = 1;
    switch (postion)
    {
    case 0x5:
        break;
    default:
        break;
    }
    return out;
}
void druck()
{
    if(DD_D==DD_d)
        return;
    else  if(DD_D)
        accept();
    DD_d=DD_D;
}
void posUpdate()
{
    postion = 0;
    for(char i = 0;i<depth-1;i++)
        postion = postion|(mSelected[i]<<(i*2));
}
void up()
{
    if(depth>0)
    {
        if(mSelected[depth-1]<1)
        {
            if(VHS==0)
                mSelected[depth-1]=3;
            else if(VHS==1)
                mSelected[depth-1]=4;
            else
                mSelected[depth-1]=VHS;
        }
        else
            mSelected[depth-1]--;
        print_pos();
    }
}
void down()
{
    if(depth>0)
    {
        char temp=3;
        if(VHS==0)
            temp=3;
        else if(VHS==1)
            temp=4;
        else
            temp=VHS;
        if(mSelected[depth-1]>(temp-1))
            mSelected[depth-1]=0;
        else
            mSelected[depth-1]++;
        print_pos();
    }
}
void accept()
{
    if(depth>0)
    {
        postion = 0;
        for(char i = 0;i<depth;i++)
            postion = postion|(mSelected[i]<<(i*2));
        char temp = ausfuhren();
        if(temp>0)
        {
            if(mSelected[depth-1]==0)
            {
                depth--;//Exit()
                mSelected[depth]=0;
            }
            else
            {
                mSelected[depth]=1;
                depth++;
            }
        }
    }
    else
        depth=1;
    posUpdate();
    if(postion==0x6)
        VHS=1;
    else
        VHS=0;
    if(depth>0)
    {
        print_menu();
        print_pos();
    }
    else
        print_default();
}
void exit()
{
    if(depth>0)
    {
        depth--;
        mSelected[depth]=0;
    }
    posUpdate();
    if(postion==0x6)
        VHS=1;
    else
        VHS=0;
    if(depth>0)
    {
        print_menu();
        print_pos();
    }
    else
        print_default();
}
void print_menu()
{
    port.printf("DR\n");
    lcd.cls();
    lcd.locate(1,0);
    lcd.printf(text_ln0[textPos[postion]]);
    port.printf("D%c%c%s\n",28,27,text_ln0[textPos[postion]]);
    lcd.locate(1,1);
    lcd.printf(text_ln1[textPos[postion]]);
    port.printf("D%c%c%s\n",28,28,text_ln1[textPos[postion]]);
    lcd.locate(1,2);
    lcd.printf(text_ln2[textPos[postion]]);
    port.printf("D%c%c%s\n",28,29,text_ln2[textPos[postion]]);
    lcd.locate(1,3);
    lcd.printf(text_ln3[textPos[postion]]);
    port.printf("D%c%c%s\n",28,30,text_ln3[textPos[postion]]);
}
void print_pos()
{
    if (VHS==1)
    {
        lcd.locate(0,3);
        //         "--------------------"
        lcd.printf("                    ");
        port.printf("D%c%c                    \n",27,27+3);

        lcd.locate(0,0);
        if(mSelected[depth-1]==0)
        {
            port.printf("D%c%c<\n",27,27);
            lcd.putc('<');
        }
        else
        {
            port.printf("D%c%c \n",27,27);
            lcd.putc(' ');

            lcd.locate(4*mSelected[depth-1],3);
            lcd.putc('^');
            port.printf("D%c%c^\n",27+4*mSelected[depth-1],27+3);
        }
    }
    else
    {
        for(char i=0;i<4;i++)
        {
            lcd.locate(0,i);
            if((mSelected[depth-1]+0)==i)
            {
                if(i==0)
                {
                    port.printf("D%c%c<\n",27,i+27);
                    lcd.putc('<');
                }
                else
                {
                    port.printf("D%c%c>\n",27,i+27);
                    lcd.putc('>');
                }
            }
            else
            {
                port.printf("D%c%c \n",27,i+27);
                lcd.putc(' ');
            }
        }
    }
}
