#include "WS2812B.h"

    RGBOut::RGBOut(PinName rPin,PinName gPin,PinName bPin) : Rout(rPin) , Gout(gPin) , Bout(bPin)
    {
        Rout=1;
        Gout=1;
        Bout=1;
    }
    void RGBOut::set_RGB(uint32_t leddata)
    {
        float r = ((leddata&0x00FF00)>>8);
        float b = ((leddata&0x0000FF));
        float g = ((leddata&0xFF0000)>>16);
        r = r/0xFF;
        g = g/0xFF;
        b = b/0xFF;
        Rout=(1-r);
        Gout=(1-g);
        Bout=(1-b);
    }
    
    void RGBOut::set(float r,float g,float b)
    {
        Rout=(1-r);
        Gout=(1-g);
        Bout=(1-b);
    }
    void RGBOut::set_r(float r)
    {
        Rout=(1-r);
    }
    void RGBOut::set_g(float g)
    {
        Gout=(1-g);
    }
    void RGBOut::set_b(float b)
    {
        Bout=(1-b);
    }


uint32_t Brightness(uint32_t leddata,char Brightness)
{
    float r = ((leddata&0x00FF00)>>8);
    float b = ((leddata&0x0000FF));
    float g = ((leddata&0xFF0000)>>16);
    r = r/0xFF;
    g = g/0xFF;
    b = b/0xFF;
    r = r*Brightness;
    g = g*Brightness;
    b = b*Brightness;
    char rNew = r;
    char gNew = g;
    char bNew = b;
    uint32_t out = ((gNew<<8)|rNew)<<8|bNew;
    return out;
}

LedOut::LedOut(PinName pin):Output(pin)
{
}

void LedOut::WriteLed(uint32_t leddata)
{ 
    int i;
       for(i=0;i<24;i++)
       {
         writeledbit((leddata&(1<<i))>0);
       }
}

void LedOut::writeledbit(char wert)  // Funktion schreibe bit
{
    int j;
    if(wert)
    {
        Output=1; // data 1
        for(j=0;j<5;j++) 
        {
        __nop();    
        }
        Output=0;
        for(j=0;j<1;j++)
        {
        __nop();   
        }
    }
    else
    {
        Output=1; // data 0
        for(j=0;j<1;j++) 
        {
        __nop();    
        }
        Output=0;
        for(j=0;j<5;j++)
        {
        __nop();   
        }
    }     
}

