
#include "FuncGenFSST3.h"


SingnedRampGen::SingnedRampGen()
{
  // sinnvolle frequenz/Periode setzen
  SetPointsPerPeriod(50);
}

void SingnedRampGen::SetPointsPerPeriod(float aPoints)
{
  _inc = 2.0/aPoints;
}

void SingnedRampGen::SetFrequ(float aFrequ)
{
  SetPointsPerPeriod(1.0/aFrequ);
}

void SingnedRampGen::CalcOneStep()
{
  val = val + _inc;
  if( val>1.0 )
    val = -1 + (val - 1.0); 
}


TriangleGen::SingnedRampGen()
{
  // sinnvolle frequenz/Periode setzen
  SetPointsPerPeriod(100);
}

void TriangleGen::SetPointsPerPeriod(float aPoints)
{
  _inc = 4.0/aPoints;
}

void TriangleGen::SetFrequ(float aFrequ)
{
  SetPointsPerPeriod(2.0/aFrequ);
}

void TriangleGen::CalcOneStep()
{
  phase = phase + _inc;
  
  if( phase>1.0 )
  {
    phase = -1 + (phase - 1.0); 
    _state++;
  }
    

}
















